/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs.provider.meta;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.DefaultFileContent;
import org.apache.geronimo.gshell.vfs.provider.meta.MetaFileSystem;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaFileObject
extends AbstractFileObject {
    private final MetaFileSystem fileSystem;
    private MetaData data;
    private FileContent content;

    public MetaFileObject(FileName fileName, MetaFileSystem fileSystem) {
        super(fileName, (AbstractFileSystem)fileSystem);
        this.fileSystem = fileSystem;
    }

    public MetaData getData() {
        if (this.data == null) {
            throw new IllegalStateException("Meta data has not been attached");
        }
        return this.data;
    }

    protected FileType doGetType() throws Exception {
        return this.getData().getType();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.getData().getLastModified();
    }

    protected boolean doIsReadable() throws Exception {
        return this.data.getBuffer() != null;
    }

    protected boolean doIsWriteable() throws Exception {
        return false;
    }

    protected FileContentInfoFactory getFileContentInfoFactory() {
        return this.fileSystem.getFileContentInfoFactory();
    }

    protected long doGetContentSize() throws Exception {
        byte[] bytes = this.data.getBuffer();
        return bytes != null ? (long)bytes.length : 0L;
    }

    protected InputStream doGetInputStream() throws Exception {
        byte[] bytes = this.data.getBuffer();
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    protected Map<String, Object> doGetAttributes() {
        return this.getData().getAttributes();
    }

    protected void doSetAttribute(String name, Object value) {
        this.getData().getAttributes().put(name, value);
    }

    protected void doRemoveAttribute(String name) {
        this.getData().getAttributes().remove(name);
    }

    protected String[] doListChildren() throws Exception {
        return this.fileSystem.listChildren(this.getName());
    }

    protected void doAttach() throws Exception {
        if (this.data == null) {
            this.data = this.fileSystem.lookupData(this);
        }
        this.content = new DefaultFileContent((AbstractFileObject)this, this.getFileContentInfoFactory());
    }

    protected void doDetach() throws Exception {
        this.data = null;
        this.content = null;
    }

    public FileContent getContent() throws FileSystemException {
        super.getContent();
        return this.content;
    }
}

