/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs.provider.meta;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.geronimo.gshell.vfs.provider.meta.MetaFileContentInfoFactory;
import org.apache.geronimo.gshell.vfs.provider.meta.MetaFileObject;
import org.apache.geronimo.gshell.vfs.provider.meta.MetaFileProvider;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaData;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaDataRegistry;

public class MetaFileSystem
extends AbstractFileSystem {
    private final MetaDataRegistry registry;
    private FileContentInfoFactory fileContentInfoFactory;

    public MetaFileSystem(MetaDataRegistry registry, FileName rootName, FileSystemOptions options) {
        super(rootName, null, options);
        assert (registry != null);
        this.registry = registry;
    }

    protected FileObject createFile(FileName fileName) throws Exception {
        return new MetaFileObject(fileName, this);
    }

    protected void addCapabilities(Collection capabilities) {
        assert (capabilities != null);
        capabilities.addAll(MetaFileProvider.CAPABILITIES);
    }

    MetaData lookupData(MetaFileObject file) throws FileSystemException {
        assert (file != null);
        FileName name = file.getName();
        if (!this.registry.containsData(name)) {
            return new MetaData(name, FileType.IMAGINARY);
        }
        return this.registry.lookupData(name);
    }

    String[] listChildren(FileName name) throws FileSystemException {
        assert (name != null);
        MetaData data = this.registry.lookupData(name);
        Collection<MetaData> children = data.getChildren();
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (MetaData child : children) {
            names.add(child.getName().getBaseName());
        }
        return names.toArray(new String[names.size()]);
    }

    FileContentInfoFactory getFileContentInfoFactory() {
        if (this.fileContentInfoFactory == null) {
            this.fileContentInfoFactory = new MetaFileContentInfoFactory();
        }
        return this.fileContentInfoFactory;
    }
}

