/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs.provider.meta.data;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.geronimo.gshell.event.EventPublisher;
import org.apache.geronimo.gshell.vfs.provider.meta.MetaFileNameParser;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaData;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaDataRegisteredEvent;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaDataRegistry;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaDataRegistryException;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaDataRemovedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataRegistryImpl
implements MetaDataRegistry {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<FileName, MetaData> nodes = new HashMap<FileName, MetaData>();
    private final EventPublisher eventPublisher;
    private String rootFileName = "meta:/";

    public MetaDataRegistryImpl(EventPublisher eventPublisher) {
        assert (eventPublisher != null);
        this.eventPublisher = eventPublisher;
    }

    public void init() throws FileSystemException {
        MetaFileNameParser parser = new MetaFileNameParser();
        FileName rootName = parser.parseUri(this.rootFileName);
        this.registerData(rootName, new MetaData(rootName, FileType.FOLDER));
    }

    protected Map<FileName, MetaData> getNodes() {
        return this.nodes;
    }

    @Override
    public void registerData(FileName name, MetaData data) {
        assert (name != null);
        assert (data != null);
        this.log.trace("Registering data: {}", (Object)name);
        if (name.getDepth() > 0) {
            MetaData parent = this.getParentData(name);
            if (parent != null) {
                if (!parent.hasChild(data)) {
                    parent.addChild(data);
                }
            } else {
                this.log.warn("Depth is > 0, but parent name is null for node: " + name);
            }
        }
        this.getNodes().put(name, data);
        this.eventPublisher.publish(new MetaDataRegisteredEvent(name, data));
    }

    private MetaData getParentData(FileName name) {
        assert (name != null);
        FileName parentName = name.getParent();
        MetaData parent = null;
        if (parentName != null) {
            if (this.containsData(parentName)) {
                parent = this.lookupData(parentName);
            } else {
                this.log.trace("Building parent tree: {}", (Object)parentName);
                parent = new MetaData(parentName, FileType.FOLDER);
                this.registerData(parentName, parent);
            }
        }
        return parent;
    }

    @Override
    public void removeData(FileName name) {
        assert (name != null);
        this.log.trace("Removing data: {}", (Object)name);
        MetaData data = this.getNodes().remove(name);
        FileName parentName = name.getParent();
        if (parentName != null && this.containsData(parentName)) {
            MetaData parent = this.lookupData(parentName);
            parent.removeChild(data);
        }
        this.eventPublisher.publish(new MetaDataRemovedEvent(name, data));
    }

    @Override
    public boolean containsData(FileName name) {
        assert (name != null);
        return this.getNodes().containsKey(name);
    }

    @Override
    public MetaData lookupData(FileName name) {
        assert (name != null);
        this.log.trace("Looking up data: {}", (Object)name);
        if (!this.containsData(name)) {
            throw new MetaDataRegistryException("No data registered for: " + name);
        }
        return this.getNodes().get(name);
    }
}

