/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.vfs.support;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.notification.ResultNotification;
import org.apache.geronimo.gshell.vfs.FileObjects;
import org.apache.geronimo.gshell.vfs.FileSystemAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public abstract class VfsActionSupport
implements CommandAction {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private FileSystemAccess fileSystemAccess;

    @Required
    public void setFileSystemAccess(FileSystemAccess fileSystemAccess) {
        assert (fileSystemAccess != null);
        this.fileSystemAccess = fileSystemAccess;
    }

    protected FileSystemAccess getFileSystemAccess() {
        assert (this.fileSystemAccess != null);
        return this.fileSystemAccess;
    }

    protected FileObject getCurrentDirectory(CommandContext context) throws FileSystemException {
        assert (context != null);
        return this.getFileSystemAccess().getCurrentDirectory(context.getVariables());
    }

    protected void setCurrentDirectory(CommandContext context, FileObject dir) throws FileSystemException {
        assert (context != null);
        this.getFileSystemAccess().setCurrentDirectory(context.getVariables(), dir);
    }

    protected FileObject resolveFile(CommandContext context, String path) throws FileSystemException {
        assert (context != null);
        assert (path != null);
        this.log.trace("Resolving path: {}", (Object)path);
        FileObject cwd = this.getCurrentDirectory(context);
        return this.getFileSystemAccess().resolveFile(cwd, path);
    }

    protected void ensureFileExists(FileObject file) throws FileSystemException {
        assert (file != null);
        if (!file.exists()) {
            FileObjects.close(file);
            throw new ResultNotification("File not found: " + file.getName(), (Object)CommandAction.Result.FAILURE);
        }
    }

    protected void ensureFileHasContent(FileObject file) throws FileSystemException {
        assert (file != null);
        if (!file.getType().hasContent()) {
            FileObjects.close(file);
            throw new ResultNotification("File has no content: " + file.getName(), (Object)CommandAction.Result.FAILURE);
        }
    }

    protected void ensureFileHasChildren(FileObject file) throws FileSystemException {
        assert (file != null);
        if (!file.getType().hasChildren()) {
            FileObjects.close(file);
            throw new ResultNotification("File has no children: " + file.getName(), (Object)CommandAction.Result.FAILURE);
        }
    }

    protected void ensureFileIsReadable(FileObject file) throws FileSystemException {
        assert (file != null);
        if (!file.getType().hasChildren()) {
            FileObjects.close(file);
            throw new ResultNotification("File is not readable: " + file.getName(), (Object)CommandAction.Result.FAILURE);
        }
    }

    protected void ensureFileIsWritable(FileObject file) throws FileSystemException {
        assert (file != null);
        if (!file.getType().hasChildren()) {
            FileObjects.close(file);
            throw new ResultNotification("File is not writable: " + file.getName(), (Object)CommandAction.Result.FAILURE);
        }
    }
}

