/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.application;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.geronimo.gshell.application.ClassPath;
import org.apache.geronimo.gshell.io.Closer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathCache {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File file;

    public ClassPathCache(File file) {
        assert (file != null);
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(ClassPath classPath) throws IOException {
        assert (classPath != null);
        this.file.getParentFile().mkdirs();
        ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        try {
            output.writeObject(classPath);
            this.log.debug("Saved classpath to cache: {}", (Object)this.file);
        }
        catch (Throwable throwable) {
            Closer.close(output);
            throw throwable;
        }
        Closer.close(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath get() {
        ClassPath classPath;
        if (!this.file.exists()) {
            return null;
        }
        try {
            ObjectInputStream input = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.file)));
            try {
                classPath = (ClassPath)input.readObject();
                this.log.debug("Loaded classpath from cache: {}", (Object)this.file);
            }
            catch (Throwable throwable) {
                Closer.close(input);
                throw throwable;
            }
            Closer.close(input);
        }
        catch (Exception e) {
            this.log.warn("Failed to load classpath from cache", (Throwable)e);
            return null;
        }
        if (classPath.isValid()) {
            return classPath;
        }
        this.log.debug("Classpath is not valid");
        return null;
    }
}

