/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.command;

import java.util.Iterator;
import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.commandline.CommandLineExecutor;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.apache.geronimo.gshell.i18n.ResourceBundleMessageSource;
import org.apache.geronimo.gshell.shell.ShellContext;
import org.apache.geronimo.gshell.shell.ShellContextHolder;
import org.apache.geronimo.gshell.wisdom.command.CommandSupport;
import org.apache.geronimo.gshell.wisdom.command.HelpSupport;
import org.apache.geronimo.gshell.wisdom.command.MessageSourceCommandDocumenter;
import org.apache.geronimo.gshell.wisdom.registry.CommandLocationImpl;

public class AliasCommand
extends CommandSupport {
    private final CommandLineExecutor executor;
    private String name;
    private String alias;

    public AliasCommand(CommandLineExecutor executor) {
        assert (executor != null);
        this.executor = executor;
        this.setAction(new AliasCommandAction());
        this.setDocumenter(new AliasCommandDocumenter());
        this.setMessages(new AliasCommandMessageSource());
    }

    public String getName() {
        if (this.name == null) {
            throw new IllegalStateException("Missing property: name");
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (name != null) {
            this.setLocation(new CommandLocationImpl(name));
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        if (alias == null) {
            throw new IllegalStateException("Missing property: alias");
        }
        this.alias = alias;
    }

    protected void prepareAction(ShellContext context, Object[] args) {
        this.setAction(new AliasCommandAction());
        super.prepareAction(context, args);
    }

    private class AliasCommandMessageSource
    implements MessageSource {
        private final MessageSource messages = new ResourceBundleMessageSource(new Class[]{AliasCommand.class, HelpSupport.class});

        private AliasCommandMessageSource() {
        }

        public String getMessage(String code) {
            return this.messages.getMessage(code);
        }

        public String format(String code, Object ... args) {
            return this.messages.format(code, args);
        }
    }

    private class AliasCommandDocumenter
    extends MessageSourceCommandDocumenter {
        private AliasCommandDocumenter() {
        }

        public String getDescription() {
            return this.getMessages().format("command.description", AliasCommand.this.getAlias());
        }
    }

    private class AliasCommandAction
    implements CommandAction {
        @Argument
        private List<String> appendArgs = null;

        private AliasCommandAction() {
        }

        public Object execute(CommandContext context) throws Exception {
            assert (context != null);
            StringBuilder buff = new StringBuilder();
            buff.append(AliasCommand.this.getAlias());
            if (this.appendArgs != null && !this.appendArgs.isEmpty()) {
                buff.append(" ");
                Iterator<String> iter = this.appendArgs.iterator();
                while (iter.hasNext()) {
                    buff.append('\"').append((Object)iter.next()).append('\"');
                    if (!iter.hasNext()) continue;
                    buff.append(" ");
                }
            }
            AliasCommand.this.log.debug("Executing alias: {}", (Object)buff);
            Object result = AliasCommand.this.executor.execute(ShellContextHolder.get(), buff.toString());
            AliasCommand.this.log.debug("Alias result: {}", result);
            return result;
        }
    }
}

