/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.command;

import java.io.PrintWriter;
import org.apache.geronimo.gshell.ansi.AnsiCode;
import org.apache.geronimo.gshell.ansi.AnsiRenderer;
import org.apache.geronimo.gshell.clp.CommandLineProcessor;
import org.apache.geronimo.gshell.clp.Printer;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandAware;
import org.apache.geronimo.gshell.command.CommandDocumenter;
import org.apache.geronimo.gshell.i18n.PrefixingMessageSource;
import org.apache.geronimo.gshell.wisdom.command.HelpSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandDocumenterSupport
implements CommandDocumenter,
CommandAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Command command;

    public void setCommand(Command command) {
        assert (command != null);
        this.command = command;
    }

    protected Command getCommand() {
        assert (this.command != null);
        return this.command;
    }

    public void renderUsage(PrintWriter out) {
        assert (out != null);
        this.log.trace("Rendering command usage");
        CommandLineProcessor clp = new CommandLineProcessor();
        HelpSupport help = new HelpSupport();
        clp.addBean(help);
        CommandAction action = this.getCommand().getAction();
        clp.addBean(action);
        out.println(this.getDescription());
        out.println();
        Printer printer = new Printer(clp);
        printer.setMessageSource(new PrefixingMessageSource(this.getCommand().getMessages(), "command."));
        printer.printUsage(out, this.getCommand().getLocation().getName());
    }

    protected abstract String getManual();

    public void renderManual(PrintWriter out) {
        assert (out != null);
        this.log.trace("Rendering command manual");
        AnsiRenderer renderer = new AnsiRenderer();
        out.println(renderer.render(AnsiRenderer.encode("NAME", AnsiCode.BOLD)));
        out.print("  ");
        out.println(this.getCommand().getLocation().getName());
        out.println();
        out.println(renderer.render(AnsiRenderer.encode("DESCRIPTION", AnsiCode.BOLD)));
        out.print("  ");
        out.println(this.getDescription());
        out.println();
        out.println(renderer.render(AnsiRenderer.encode("MANUAL", AnsiCode.BOLD)));
        out.println(this.getManual());
        out.println();
    }
}

