/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.command;

import org.apache.geronimo.gshell.clp.CommandLineProcessor;
import org.apache.geronimo.gshell.command.Arguments;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandAware;
import org.apache.geronimo.gshell.command.CommandCompleter;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.command.CommandDocumenter;
import org.apache.geronimo.gshell.command.CommandLocation;
import org.apache.geronimo.gshell.command.CommandResult;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.notification.Notification;
import org.apache.geronimo.gshell.notification.ResultNotification;
import org.apache.geronimo.gshell.shell.ShellContext;
import org.apache.geronimo.gshell.spring.BeanContainer;
import org.apache.geronimo.gshell.spring.BeanContainerAware;
import org.apache.geronimo.gshell.wisdom.command.HelpSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandSupport
implements Command,
BeanContainerAware {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private CommandLocation location;
    private CommandAction action;
    private CommandDocumenter documenter;
    private CommandCompleter completer;
    private MessageSource messages;
    private BeanContainer container;

    public CommandLocation getLocation() {
        if (this.location == null) {
            throw new IllegalStateException("Missing required property: location");
        }
        return this.location;
    }

    public void setLocation(CommandLocation location) {
        assert (location != null);
        this.handleCommandAware(location);
        this.log.trace("Location: {}", (Object)location);
        this.location = location;
    }

    public CommandAction getAction() {
        if (this.action == null) {
            throw new IllegalStateException("Missing required property: action");
        }
        return this.action;
    }

    protected void setAction(CommandAction action) {
        assert (action != null);
        this.handleCommandAware(action);
        this.log.trace("Action: {}", (Object)action);
        this.action = action;
    }

    public CommandDocumenter getDocumenter() {
        if (this.documenter == null) {
            throw new IllegalStateException("Missing required property: documenter");
        }
        return this.documenter;
    }

    protected void setDocumenter(CommandDocumenter documenter) {
        assert (documenter != null);
        this.handleCommandAware(documenter);
        this.log.trace("Documenter: {}", (Object)documenter);
        this.documenter = documenter;
    }

    public CommandCompleter getCompleter() {
        return this.completer;
    }

    protected void setCompleter(CommandCompleter completer) {
        assert (completer != null);
        this.handleCommandAware(completer);
        this.log.trace("Completer: {}", (Object)completer);
        this.completer = completer;
    }

    public MessageSource getMessages() {
        if (this.messages == null) {
            throw new IllegalStateException("Missing required property: messages");
        }
        return this.messages;
    }

    protected void setMessages(MessageSource messages) {
        assert (messages != null);
        this.handleCommandAware(messages);
        this.log.trace("Messages: {}", (Object)messages);
        this.messages = messages;
    }

    protected void handleCommandAware(Object target) {
        assert (target != null);
        if (target instanceof CommandAware) {
            ((CommandAware)target).setCommand(this);
        }
    }

    public void setBeanContainer(BeanContainer container) {
        assert (container != null);
        this.container = container;
    }

    protected BeanContainer getContainer() {
        if (this.container == null) {
            throw new IllegalStateException("Bean container not configured");
        }
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult execute(ShellContext context, Object[] args) {
        CommandResult result;
        assert (context != null);
        assert (args != null);
        this.log.trace("Executing");
        ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            this.prepareAction(context, args);
            result = this.executeAction(context, args);
        }
        catch (AbortExecutionNotification n) {
            result = n.result;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevCL);
        }
        return result;
    }

    protected void prepareAction(ShellContext context, Object[] args) {
        assert (context != null);
        assert (args != null);
        this.log.trace("Preparing action");
        IO io = context.getIo();
        CommandAction action = this.getAction();
        try {
            this.processArguments(io, action, args);
        }
        catch (Exception e) {
            throw new AbortExecutionNotification(new CommandResult.FailureResult(e));
        }
    }

    protected void processArguments(IO io, CommandAction action, Object[] args) throws Exception {
        assert (io != null);
        assert (action != null);
        assert (args != null);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Processing arguments: {}", (Object[])Arguments.toStringArray(args));
        }
        CommandLineProcessor clp = new CommandLineProcessor();
        clp.addBean(action);
        HelpSupport help = new HelpSupport();
        clp.addBean(help);
        clp.process(Arguments.toStringArray(args));
        if (help.displayHelp) {
            this.log.trace("Render command-line usage");
            CommandDocumenter documenter = this.getDocumenter();
            documenter.renderUsage(io.out);
            throw new AbortExecutionNotification(new CommandResult.ValueResult((Object)CommandAction.Result.SUCCESS));
        }
    }

    protected CommandResult executeAction(final ShellContext context, final Object[] args) {
        CommandResult result;
        assert (context != null);
        assert (args != null);
        final IO io = context.getIo();
        this.log.trace("Executing action");
        CommandContext ctx = new CommandContext(){
            private final Variables variables;
            {
                this.variables = new Variables(context.getVariables());
            }

            public Object[] getArguments() {
                return args;
            }

            public IO getIo() {
                return io;
            }

            public Variables getVariables() {
                return this.variables;
            }

            public Command getCommand() {
                return CommandSupport.this;
            }
        };
        try {
            CommandAction action = this.getAction();
            this.log.trace("Executing action: {}", (Object)action);
            Object value = action.execute(ctx);
            this.log.trace("Result: {}", value);
            context.getVariables().set("gshell.result", value);
            result = new CommandResult.ValueResult(value);
        }
        catch (ResultNotification n) {
            this.log.trace("Command notified result: " + n, (Throwable)n);
            if (n.getResult() == CommandAction.Result.FAILURE) {
                io.error(n.getMessage());
            } else {
                io.verbose(n.getMessage());
            }
            result = new CommandResult.ValueResult(n.getResult());
        }
        catch (Notification n) {
            this.log.trace("Notified: " + n, (Throwable)n);
            result = new CommandResult.NotificationResult(n);
        }
        catch (Throwable t) {
            this.log.trace("Caught: " + t, t);
            result = new CommandResult.FailureResult(t);
        }
        return result;
    }

    protected class AbortExecutionNotification
    extends Notification {
        public final CommandResult result;

        public AbortExecutionNotification(CommandResult result) {
            assert (result != null);
            this.result = result;
        }
    }
}

