/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.command;

import org.apache.geronimo.gshell.chronos.StopWatch;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandCompleter;
import org.apache.geronimo.gshell.command.CommandDocumenter;
import org.apache.geronimo.gshell.command.CommandResult;
import org.apache.geronimo.gshell.i18n.MessageSource;
import org.apache.geronimo.gshell.shell.ShellContext;
import org.apache.geronimo.gshell.wisdom.command.CommandSupport;

public class StatefulCommand
extends CommandSupport {
    private final ThreadLocal<CommandAction> actionHolder = new ThreadLocal();
    private String actionId;

    public String getActionId() {
        if (this.actionId == null) {
            throw new IllegalStateException("Missing required property: actionId");
        }
        return this.actionId;
    }

    public void setActionId(String actionId) {
        assert (actionId != null);
        this.actionId = actionId;
    }

    public synchronized CommandAction getAction() {
        CommandAction action = this.actionHolder.get();
        if (action == null) {
            StopWatch watch = new StopWatch(true);
            action = this.createAction();
            this.setAction(action);
            this.log.trace("Action created in {}", (Object)watch);
        }
        return action;
    }

    protected synchronized void setAction(CommandAction action) {
        super.setAction(action);
        this.actionHolder.set(action);
    }

    private synchronized CommandAction createAction() {
        String id = this.getActionId();
        this.log.trace("Creating action for ID: {}", (Object)id);
        return this.getContainer().getBean(id, CommandAction.class);
    }

    private synchronized void clearAction() {
        this.actionHolder.remove();
        this.log.trace("Action cleared");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommandResult executeAction(ShellContext context, Object[] args) {
        try {
            CommandResult commandResult = super.executeAction(context, args);
            return commandResult;
        }
        finally {
            this.clearAction();
        }
    }

    public void setDocumenter(CommandDocumenter documenter) {
        super.setDocumenter(documenter);
    }

    public void setCompleter(CommandCompleter completer) {
        super.setCompleter(completer);
    }

    public void setMessages(MessageSource messages) {
        super.setMessages(messages);
    }
}

