/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.completer;

import java.util.Collection;
import java.util.List;
import jline.Completor;
import org.apache.geronimo.gshell.console.completer.StringsCompleter;
import org.apache.geronimo.gshell.event.Event;
import org.apache.geronimo.gshell.event.EventListener;
import org.apache.geronimo.gshell.event.EventManager;
import org.apache.geronimo.gshell.registry.CommandRegistry;
import org.apache.geronimo.gshell.wisdom.registry.CommandRegisteredEvent;
import org.apache.geronimo.gshell.wisdom.registry.CommandRemovedEvent;

public class CommandNameCompleter
implements Completor {
    private final EventManager eventManager;
    private final CommandRegistry commandRegistry;
    private final StringsCompleter delegate = new StringsCompleter();

    public CommandNameCompleter(EventManager eventManager, CommandRegistry commandRegistry) {
        assert (eventManager != null);
        this.eventManager = eventManager;
        assert (commandRegistry != null);
        this.commandRegistry = commandRegistry;
    }

    public void init() {
        Collection<String> names = this.commandRegistry.getCommandNames();
        this.delegate.getStrings().addAll(names);
        this.eventManager.addListener(new EventListener(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof CommandRegisteredEvent) {
                    CommandRegisteredEvent targetEvent = (CommandRegisteredEvent)event;
                    CommandNameCompleter.this.delegate.getStrings().add(targetEvent.getName());
                } else if (event instanceof CommandRemovedEvent) {
                    CommandRemovedEvent targetEvent = (CommandRemovedEvent)event;
                    CommandNameCompleter.this.delegate.getStrings().remove(targetEvent.getName());
                }
            }
        });
    }

    public int complete(String buffer, int cursor, List candidates) {
        return this.delegate.complete(buffer, cursor, candidates);
    }
}

