/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.completer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.ArgumentCompletor;
import jline.Completor;
import org.apache.commons.vfs.FileName;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandCompleter;
import org.apache.geronimo.gshell.console.completer.AggregateCompleter;
import org.apache.geronimo.gshell.console.completer.StringsCompleter;
import org.apache.geronimo.gshell.event.Event;
import org.apache.geronimo.gshell.event.EventListener;
import org.apache.geronimo.gshell.event.EventManager;
import org.apache.geronimo.gshell.registry.CommandRegistry;
import org.apache.geronimo.gshell.wisdom.completer.NullCompleter;
import org.apache.geronimo.gshell.wisdom.registry.CommandRegisteredEvent;
import org.apache.geronimo.gshell.wisdom.registry.CommandRemovedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandsCompleter
implements Completor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EventManager eventManager;
    private final CommandRegistry commandRegistry;
    private final Map<String, Completor> completors = new HashMap<String, Completor>();
    private final Map<FileName, Completor> groupCompleters = new HashMap<FileName, Completor>();
    private final AggregateCompleter delegate = new AggregateCompleter();

    public CommandsCompleter(EventManager eventManager, CommandRegistry commandRegistry) {
        assert (eventManager != null);
        this.eventManager = eventManager;
        assert (commandRegistry != null);
        this.commandRegistry = commandRegistry;
    }

    public void init() throws Exception {
        Collection<String> names = this.commandRegistry.getCommandNames();
        for (String name : names) {
            Command command = this.commandRegistry.getCommand(name);
            this.addCompleter(name, command);
        }
        this.eventManager.addListener(new EventListener(){

            public void onEvent(Event event) throws Exception {
                if (event instanceof CommandRegisteredEvent) {
                    CommandRegisteredEvent targetEvent = (CommandRegisteredEvent)event;
                    CommandsCompleter.this.addCompleter(targetEvent.getName(), targetEvent.getCommand());
                } else if (event instanceof CommandRemovedEvent) {
                    CommandRemovedEvent targetEvent = (CommandRemovedEvent)event;
                    CommandsCompleter.this.removeCompleter(targetEvent.getName());
                }
            }
        });
    }

    private void addCompleter(String name, Command command) {
        assert (name != null);
        assert (command != null);
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(new StringsCompleter(new String[]{name}));
        CommandCompleter commandCompleter = command.getCompleter();
        if (commandCompleter != null) {
            Collection<Completor> commandCompleters = commandCompleter.createCompletors();
            if (commandCompleters != null) {
                for (Completor completer : commandCompleters) {
                    children.add(completer != null ? completer : NullCompleter.INSTANCE);
                }
            } else {
                children.add((Object)NullCompleter.INSTANCE);
            }
        } else {
            children.add((Object)NullCompleter.INSTANCE);
        }
        ArgumentCompletor root = new ArgumentCompletor(children);
        this.completors.put(name, (Completor)root);
        this.delegate.getCompleters().add((Completor)root);
    }

    private void removeCompleter(String name) {
        assert (name != null);
        Completor completer = this.completors.remove(name);
        this.delegate.getCompleters().remove(completer);
    }

    public int complete(String buffer, int cursor, List candidates) {
        return this.delegate.complete(buffer, cursor, candidates);
    }
}

