/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.plugin;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.geronimo.gshell.application.Application;
import org.apache.geronimo.gshell.application.ApplicationManager;
import org.apache.geronimo.gshell.application.ClassPath;
import org.apache.geronimo.gshell.application.plugin.Plugin;
import org.apache.geronimo.gshell.application.plugin.PluginManager;
import org.apache.geronimo.gshell.artifact.Artifact;
import org.apache.geronimo.gshell.artifact.ArtifactResolver;
import org.apache.geronimo.gshell.chronos.StopWatch;
import org.apache.geronimo.gshell.event.Event;
import org.apache.geronimo.gshell.event.EventListener;
import org.apache.geronimo.gshell.event.EventManager;
import org.apache.geronimo.gshell.spring.BeanContainer;
import org.apache.geronimo.gshell.spring.BeanContainerAware;
import org.apache.geronimo.gshell.wisdom.application.ApplicationConfiguredEvent;
import org.apache.geronimo.gshell.wisdom.application.ClassPathCache;
import org.apache.geronimo.gshell.wisdom.application.ClassPathImpl;
import org.apache.geronimo.gshell.wisdom.plugin.PluginArtifactFilter;
import org.apache.geronimo.gshell.wisdom.plugin.PluginImpl;
import org.apache.geronimo.gshell.wisdom.plugin.PluginLoadedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManagerImpl
implements PluginManager,
BeanContainerAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ApplicationManager applicationManager;
    private final EventManager eventManager;
    private ArtifactResolver artifactResolver;
    private BeanContainer container;
    private Set<Plugin> plugins = new LinkedHashSet<Plugin>();

    public PluginManagerImpl(ApplicationManager applicationManager, EventManager eventManager, ArtifactResolver artifactResolver) {
        assert (applicationManager != null);
        this.applicationManager = applicationManager;
        assert (eventManager != null);
        this.eventManager = eventManager;
        assert (artifactResolver != null);
        this.artifactResolver = artifactResolver;
    }

    @Override
    public void setBeanContainer(BeanContainer container) {
        assert (container != null);
        this.container = container;
    }

    public void init() {
        assert (this.eventManager != null);
        this.eventManager.addListener(new EventListener(){

            public void onEvent(Event event) throws Exception {
                assert (event != null);
                if (event instanceof ApplicationConfiguredEvent) {
                    ApplicationConfiguredEvent targetEvent = (ApplicationConfiguredEvent)event;
                    PluginManagerImpl.this.loadPlugins(targetEvent.getApplication());
                }
            }
        });
    }

    @Override
    public Set<Plugin> getPlugins() {
        return this.plugins;
    }

    private void loadPlugins(Application application) {
        assert (application != null);
        this.log.debug("Loading plugins for application: {}", (Object)application.getId());
        List<Artifact> artifacts = application.getModel().getPlugins();
        for (Artifact artifact : artifacts) {
            try {
                this.loadPlugin(application, artifact);
            }
            catch (Exception e) {
                this.log.error("Failed to load plugin: " + artifact, (Throwable)e);
            }
        }
    }

    private void loadPlugin(Application application, Artifact artifact) throws Exception {
        assert (application != null);
        assert (artifact != null);
        StopWatch watch = new StopWatch(true);
        this.log.debug("Loading plugin: {}", (Object)artifact.getId());
        ClassPath classPath = this.loadClassPath(application, artifact);
        BeanContainer pluginContainer = this.container.createChild(classPath.getUrls());
        this.log.debug("Created plugin container: {}", (Object)pluginContainer);
        pluginContainer.loadBeans(new String[]{"classpath*:META-INF/gshell/components.xml"});
        PluginImpl plugin = pluginContainer.getBean(PluginImpl.class);
        plugin.initArtifact(artifact);
        plugin.initClassPath(classPath);
        this.plugins.add(plugin);
        this.log.debug("Activating plugin: {}", (Object)plugin.getName());
        plugin.activate();
        this.log.debug("Loaded plugin in: {}", (Object)watch);
        this.eventManager.getPublisher().publish(new PluginLoadedEvent(plugin, artifact));
    }

    private ClassPath loadClassPath(Application application, Artifact artifact) throws Exception {
        assert (application != null);
        assert (artifact != null);
        ClassPathCache cache = new ClassPathCache(new File(new File(System.getProperty("gshell.home")), "var/" + artifact.getGroup() + "/" + artifact.getName() + "/classpath.ser"));
        ClassPath classPath = cache.get();
        if (classPath == null) {
            Collection<Artifact> artifacts = this.resolveArtifacts(application, artifact);
            classPath = new ClassPathImpl(artifacts);
            cache.set(classPath);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Plugin classpath:");
            for (URL url : classPath.getUrls()) {
                this.log.debug("    {}", (Object)url);
            }
        }
        return classPath;
    }

    @Override
    public void loadPlugin(Artifact artifact) throws Exception {
        assert (this.applicationManager != null);
        this.loadPlugin(this.applicationManager.getApplication(), artifact);
    }

    private Collection<Artifact> resolveArtifacts(Application application, Artifact artifact) throws Exception {
        assert (application != null);
        assert (artifact != null);
        this.log.debug("Resolving plugin artifacts");
        ArtifactResolver.Request request = new ArtifactResolver.Request();
        request.filter = new PluginArtifactFilter(application);
        request.artifact = application.getArtifact();
        request.artifacts = Collections.singletonList(artifact);
        ArtifactResolver.Result result = this.artifactResolver.resolve(request);
        return result.artifacts;
    }
}

