/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.plugin;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.geronimo.gshell.application.plugin.Plugin;
import org.apache.geronimo.gshell.event.Event;
import org.apache.geronimo.gshell.event.EventListener;
import org.apache.geronimo.gshell.event.EventManager;
import org.apache.geronimo.gshell.vfs.provider.meta.MetaFileNameParser;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaData;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaDataRegistry;
import org.apache.geronimo.gshell.wisdom.plugin.PluginLoadedEvent;

public class PluginMetaMapper
implements EventListener {
    private final EventManager eventManager;
    private final MetaDataRegistry metaRegistry;
    private final MetaFileNameParser nameParser = new MetaFileNameParser();

    public PluginMetaMapper(EventManager eventManager, MetaDataRegistry metaRegistry) {
        assert (eventManager != null);
        this.eventManager = eventManager;
        assert (metaRegistry != null);
        this.metaRegistry = metaRegistry;
    }

    public synchronized void init() {
        this.eventManager.addListener(this);
    }

    public synchronized void onEvent(Event event) throws Exception {
        assert (event != null);
        if (event instanceof PluginLoadedEvent) {
            PluginLoadedEvent targetEvent = (PluginLoadedEvent)event;
            this.add(targetEvent.getPlugin());
        }
    }

    private FileName createName(String name) throws FileSystemException {
        assert (name != null);
        return this.nameParser.parseUri("/plugins/" + name);
    }

    private void add(Plugin plugin) throws Exception {
        assert (plugin != null);
        FileName fileName = this.createName(plugin.getName());
        MetaData data = new MetaData(fileName, FileType.FILE);
        data.addAttribute("PLUGIN", plugin);
        this.metaRegistry.registerData(fileName, data);
    }

    private void remove(String name) throws Exception {
        assert (name != null);
        FileName fileName = this.createName(name);
        this.metaRegistry.removeData(fileName);
    }
}

