/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.plugin.bundle;

import org.apache.geronimo.gshell.application.plugin.bundle.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BundleSupport
implements Bundle {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private boolean enabled = false;

    protected BundleSupport(String name) {
        assert (name != null);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void enable() throws Exception {
        if (this.enabled) {
            throw new IllegalStateException("Bundle already enabled: " + this.name);
        }
        this.log.debug("Enabling bundle: {}", (Object)this.name);
        this.doEnable();
        this.enabled = true;
    }

    protected abstract void doEnable() throws Exception;

    public synchronized void disable() throws Exception {
        if (!this.enabled) {
            throw new IllegalStateException("Bundle not enabled: " + this.name);
        }
        this.log.debug("Disabling bundle: {}", (Object)this.name);
        this.doDisable();
        this.enabled = false;
    }

    protected abstract void doDisable() throws Exception;
}

