/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.registry;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.geronimo.gshell.event.Event;
import org.apache.geronimo.gshell.event.EventListener;
import org.apache.geronimo.gshell.event.EventManager;
import org.apache.geronimo.gshell.registry.AliasRegistry;
import org.apache.geronimo.gshell.vfs.provider.meta.MetaFileNameParser;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaData;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaDataRegistry;
import org.apache.geronimo.gshell.wisdom.registry.AliasRegisteredEvent;
import org.apache.geronimo.gshell.wisdom.registry.AliasRemovedEvent;

public class AliasMetaMapper
implements EventListener {
    private final EventManager eventManager;
    private final MetaDataRegistry metaRegistry;
    private final AliasRegistry aliasRegistry;
    private final MetaFileNameParser nameParser = new MetaFileNameParser();

    public AliasMetaMapper(EventManager eventManager, MetaDataRegistry metaRegistry, AliasRegistry aliasRegistry) {
        assert (eventManager != null);
        this.eventManager = eventManager;
        assert (metaRegistry != null);
        this.metaRegistry = metaRegistry;
        assert (aliasRegistry != null);
        this.aliasRegistry = aliasRegistry;
    }

    public synchronized void init() throws Exception {
        for (String name : this.aliasRegistry.getAliasNames()) {
            this.add(name, this.aliasRegistry.getAlias(name));
        }
        this.eventManager.addListener(this);
    }

    public synchronized void onEvent(Event event) throws Exception {
        assert (event != null);
        if (event instanceof AliasRegisteredEvent) {
            AliasRegisteredEvent targetEvent = (AliasRegisteredEvent)event;
            this.add(targetEvent.getName(), targetEvent.getAlias());
        } else if (event instanceof AliasRemovedEvent) {
            AliasRemovedEvent targetEvent = (AliasRemovedEvent)event;
            this.remove(targetEvent.getName());
        }
    }

    private FileName createName(String name) throws FileSystemException {
        assert (name != null);
        return this.nameParser.parseUri("meta:/aliases/" + name);
    }

    private void add(String name, String alias) throws Exception {
        assert (name != null);
        assert (alias != null);
        FileName fileName = this.createName(name);
        MetaData data = new MetaData(fileName, FileType.FILE);
        data.addAttribute("ALIAS", alias);
        this.metaRegistry.registerData(fileName, data);
    }

    private void remove(String name) throws Exception {
        assert (name != null);
        FileName fileName = this.createName(name);
        this.metaRegistry.removeData(fileName);
    }
}

