/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.registry;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.event.Event;
import org.apache.geronimo.gshell.event.EventListener;
import org.apache.geronimo.gshell.event.EventManager;
import org.apache.geronimo.gshell.registry.CommandRegistry;
import org.apache.geronimo.gshell.vfs.provider.meta.MetaFileNameParser;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaData;
import org.apache.geronimo.gshell.vfs.provider.meta.data.MetaDataRegistry;
import org.apache.geronimo.gshell.wisdom.registry.CommandRegisteredEvent;
import org.apache.geronimo.gshell.wisdom.registry.CommandRemovedEvent;

public class CommandMetaMapper
implements EventListener {
    private final EventManager eventManager;
    private final MetaDataRegistry metaRegistry;
    private final CommandRegistry commandRegistry;
    private final MetaFileNameParser nameParser = new MetaFileNameParser();

    public CommandMetaMapper(EventManager eventManager, MetaDataRegistry metaRegistry, CommandRegistry commandRegistry) {
        assert (eventManager != null);
        this.eventManager = eventManager;
        assert (metaRegistry != null);
        this.metaRegistry = metaRegistry;
        assert (commandRegistry != null);
        this.commandRegistry = commandRegistry;
    }

    public synchronized void init() throws Exception {
        for (String name : this.commandRegistry.getCommandNames()) {
            this.add(name, this.commandRegistry.getCommand(name));
        }
        this.eventManager.addListener(this);
    }

    public synchronized void onEvent(Event event) throws Exception {
        assert (event != null);
        if (event instanceof CommandRegisteredEvent) {
            CommandRegisteredEvent targetEvent = (CommandRegisteredEvent)event;
            this.add(targetEvent.getName(), targetEvent.getCommand());
        } else if (event instanceof CommandRemovedEvent) {
            CommandRemovedEvent targetEvent = (CommandRemovedEvent)event;
            this.remove(targetEvent.getName());
        }
    }

    private FileName createName(String name) throws FileSystemException {
        assert (name != null);
        return this.nameParser.parseUri("meta:/commands/" + name);
    }

    private void add(String name, Command command) throws Exception {
        assert (name != null);
        assert (command != null);
        FileName fileName = this.createName(name);
        MetaData data = new MetaData(fileName, FileType.FILE);
        data.addAttribute("COMMAND", command);
        this.metaRegistry.registerData(fileName, data);
    }

    private void remove(String name) throws Exception {
        assert (name != null);
        FileName fileName = this.createName(name);
        this.metaRegistry.removeData(fileName);
    }
}

