/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.event.EventPublisher;
import org.apache.geronimo.gshell.registry.CommandRegistry;
import org.apache.geronimo.gshell.registry.DuplicateCommandException;
import org.apache.geronimo.gshell.registry.NoSuchCommandException;
import org.apache.geronimo.gshell.wisdom.registry.CommandRegisteredEvent;
import org.apache.geronimo.gshell.wisdom.registry.CommandRemovedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandRegistryImpl
implements CommandRegistry {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EventPublisher eventPublisher;
    private final Map<String, Command> commands = new LinkedHashMap<String, Command>();

    public CommandRegistryImpl(EventPublisher eventPublisher) {
        assert (eventPublisher != null);
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void registerCommand(Command command) throws DuplicateCommandException {
        assert (command != null);
        String name = command.getLocation().getFullPath();
        this.log.debug("Registering command: {} -> {}", (Object)name, (Object)command);
        if (this.containsCommand(name)) {
            throw new DuplicateCommandException(name);
        }
        this.commands.put(name, command);
        this.eventPublisher.publish(new CommandRegisteredEvent(name, command));
    }

    @Override
    public void removeCommand(Command command) throws NoSuchCommandException {
        assert (command != null);
        String name = command.getLocation().getFullPath();
        this.log.debug("Removing command: {}", (Object)name);
        if (!this.containsCommand(name)) {
            throw new NoSuchCommandException(name);
        }
        this.commands.remove(name);
        this.eventPublisher.publish(new CommandRemovedEvent(name));
    }

    @Override
    public Command getCommand(String name) throws NoSuchCommandException {
        assert (name != null);
        if (!this.containsCommand(name)) {
            throw new NoSuchCommandException(name);
        }
        return this.commands.get(name);
    }

    @Override
    public boolean containsCommand(String name) {
        assert (name != null);
        return this.commands.containsKey(name);
    }

    @Override
    public Collection<String> getCommandNames() {
        return Collections.unmodifiableSet(this.commands.keySet());
    }
}

