/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandException;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.registry.CommandResolver;
import org.apache.geronimo.gshell.registry.NoSuchCommandException;
import org.apache.geronimo.gshell.spring.BeanContainer;
import org.apache.geronimo.gshell.spring.BeanContainerAware;
import org.apache.geronimo.gshell.vfs.FileSystemAccess;
import org.apache.geronimo.gshell.wisdom.command.AliasCommand;
import org.apache.geronimo.gshell.wisdom.command.GroupCommand;
import org.apache.geronimo.gshell.wisdom.registry.GroupDirectoryResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandResolverImpl
implements CommandResolver,
BeanContainerAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FileSystemAccess fileSystemAccess;
    private final GroupDirectoryResolver groupDirResolver;
    private FileObject commandsRoot;
    private FileObject aliasesRoot;
    private BeanContainer container;

    public CommandResolverImpl(FileSystemAccess fileSystemAccess, GroupDirectoryResolver groupDirResolver) {
        assert (fileSystemAccess != null);
        this.fileSystemAccess = fileSystemAccess;
        assert (groupDirResolver != null);
        this.groupDirResolver = groupDirResolver;
    }

    @Override
    public void setBeanContainer(BeanContainer container) {
        assert (container != null);
        this.container = container;
    }

    @Override
    public Command resolveCommand(String name, Variables variables) throws CommandException {
        assert (name != null);
        assert (variables != null);
        this.log.debug("Resolving command name: {}", (Object)name);
        Command command = this.resolveAliasCommand(name, variables);
        if (command == null) {
            try {
                FileObject file = this.resolveCommandFile(name, variables);
                if (file != null) {
                    command = this.createCommand(file);
                }
            }
            catch (FileSystemException e) {
                this.log.warn("Unable to resolve command for name: " + name, (Throwable)e);
            }
        }
        if (command == null) {
            throw new NoSuchCommandException(name);
        }
        this.log.debug("Resolved command: {}", (Object)command);
        return command;
    }

    private FileObject getAliasesRoot() throws FileSystemException {
        if (this.aliasesRoot == null) {
            this.aliasesRoot = this.fileSystemAccess.createVirtualFileSystem("meta:/aliases");
        }
        return this.aliasesRoot;
    }

    private AliasCommand resolveAliasCommand(String name, Variables variables) {
        assert (name != null);
        assert (variables != null);
        this.log.trace("Resolving alias for name: {}", (Object)name);
        AliasCommand command = null;
        try {
            FileObject root = this.getAliasesRoot();
            FileObject file = root.resolveFile(name);
            if (file != null && file.exists()) {
                this.log.trace("Resolved file: {}", (Object)file);
                command = this.createAliasCommand(file);
            }
        }
        catch (FileSystemException e) {
            this.log.debug("Failed to resolve alias command for name: " + name, (Throwable)e);
        }
        return command;
    }

    private FileObject getCommandsRoot() throws FileSystemException {
        if (this.commandsRoot == null) {
            this.commandsRoot = this.fileSystemAccess.createVirtualFileSystem("meta:/commands");
        }
        return this.commandsRoot;
    }

    private FileObject resolveCommandFile(String name, Variables variables) throws FileSystemException {
        assert (name != null);
        assert (variables != null);
        this.log.trace("Resolving command file: {}", (Object)name);
        FileObject root = this.getCommandsRoot();
        if (name.equals("/")) {
            return root;
        }
        if (name.equals(".")) {
            return this.groupDirResolver.getGroupDirectory(variables);
        }
        Collection<String> searchPath = this.getSearchPath(variables);
        this.log.trace("Search path: {}", searchPath);
        FileObject groupDir = this.groupDirResolver.getGroupDirectory(variables);
        this.log.trace("Group dir: {}", (Object)groupDir);
        FileObject file = null;
        for (String pathElement : searchPath) {
            this.log.trace("Resolving file; name={}, pathElement={}", (Object)name, (Object)pathElement);
            FileObject dir = pathElement.equals("/") ? root : (pathElement.startsWith("/") ? this.fileSystemAccess.resolveFile(root, pathElement.substring(1, pathElement.length())) : this.fileSystemAccess.resolveFile(groupDir, pathElement));
            this.log.trace("Dir: {}", (Object)dir);
            FileObject tmp = this.fileSystemAccess.resolveFile(dir, name);
            this.log.trace("File: {}", (Object)tmp);
            if (!tmp.exists()) continue;
            file = tmp;
            break;
        }
        if (file != null) {
            this.log.trace("Resolved file: {}", file);
        }
        return file;
    }

    private Collection<String> getSearchPath(Variables vars) {
        assert (vars != null);
        Object tmp = vars.get("gshell.path");
        if (tmp instanceof String) {
            return Arrays.asList(((String)tmp).split(":"));
        }
        if (tmp != null) {
            this.log.error("Invalid type for variable 'gshell.path'; expected String; found: " + tmp.getClass());
        }
        return Arrays.asList(".", "/");
    }

    @Override
    public Collection<Command> resolveCommands(String name, Variables variables) throws CommandException {
        assert (variables != null);
        if (name == null) {
            name = "";
        }
        this.log.debug("Resolving commands for name: {}", (Object)name);
        ArrayList<Command> commands = new ArrayList<Command>();
        try {
            FileObject file = this.resolveCommandFile(name, variables);
            this.log.trace("Resolved (for commands): {}", (Object)file);
            if (file != null && file.exists()) {
                if (file.getType().hasChildren()) {
                    for (FileObject child : file.getChildren()) {
                        Command command = this.createCommand(child);
                        commands.add(command);
                    }
                } else {
                    Command command = this.createCommand(file);
                    commands.add(command);
                }
            }
        }
        catch (FileSystemException e) {
            this.log.warn("Failed to resolve commands for name: " + name, (Throwable)e);
        }
        this.log.debug("Resolved {} commands", (Object)commands.size());
        if (this.log.isTraceEnabled()) {
            for (Command command : commands) {
                this.log.trace("    {}", (Object)command);
            }
        }
        return commands;
    }

    private Command createCommand(FileObject file) throws FileSystemException, CommandException {
        FileContent content;
        assert (file != null);
        file = this.fileSystemAccess.dereference(file);
        this.log.trace("Creating command for file: {} ({})", (Object)file, file.getClass());
        Command command = null;
        if (file.exists() && (command = (Command)(content = file.getContent()).getAttribute("COMMAND")) == null && file.getType().hasChildren()) {
            command = this.createGroupCommand(file);
            content.setAttribute("COMMAND", (Object)command);
        }
        if (command == null) {
            throw new CommandException("Unable to create command for file: " + file.getName());
        }
        return command;
    }

    private AliasCommand createAliasCommand(FileObject file) throws FileSystemException {
        assert (file != null);
        String name = file.getName().getBaseName();
        this.log.trace("Creating command for alias: {}", (Object)name);
        AliasCommand command = this.container.getBean(AliasCommand.class);
        String alias = (String)file.getContent().getAttribute("ALIAS");
        if (alias == null) {
            throw new IllegalStateException("Alias meta-file does not contain 'ALIAS' attribute: " + file);
        }
        command.setName(name);
        command.setAlias(alias);
        return command;
    }

    private GroupCommand createGroupCommand(FileObject file) throws FileSystemException {
        assert (file != null);
        this.log.trace("Creating command for group: {}", (Object)file);
        GroupCommand command = this.container.getBean(GroupCommand.class);
        String path = this.fileSystemAccess.dereference(this.commandsRoot).getName().getRelativeName(file.getName());
        if (".".equals(path)) {
            path = "/";
        }
        command.setPath(path);
        return command;
    }
}

