/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.wisdom.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jline.Completor;
import jline.History;
import org.apache.geronimo.gshell.application.Application;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.commandline.CommandLineExecutor;
import org.apache.geronimo.gshell.console.Console;
import org.apache.geronimo.gshell.console.JLineConsole;
import org.apache.geronimo.gshell.console.completer.AggregateCompleter;
import org.apache.geronimo.gshell.io.Closer;
import org.apache.geronimo.gshell.io.IO;
import org.apache.geronimo.gshell.notification.ExitNotification;
import org.apache.geronimo.gshell.shell.Shell;
import org.apache.geronimo.gshell.shell.ShellContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellImpl
implements Shell {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Application application;
    private final CommandLineExecutor executor;
    private History history;
    private List<Completor> completers;
    private ShellContext context;
    private Console.Prompter prompter;
    private Console.ErrorHandler errorHandler;
    private boolean opened;

    public ShellImpl(Application application, CommandLineExecutor executor) {
        assert (application != null);
        this.application = application;
        assert (executor != null);
        this.executor = executor;
    }

    private synchronized void ensureOpened() {
        if (!this.opened) {
            throw new IllegalStateException("Shell has not been opened or has been closed");
        }
    }

    @Override
    public synchronized boolean isOpened() {
        return true;
    }

    public synchronized void init() throws Exception {
        if (this.opened) {
            throw new IllegalStateException("Shell is already opened");
        }
        this.log.debug("Initializing");
        assert (this.application != null);
        final Variables vars = new Variables(this.application.getVariables());
        this.context = new ShellContext(){

            public Shell getShell() {
                return ShellImpl.this;
            }

            public IO getIo() {
                return ShellImpl.this.application.getIo();
            }

            public Variables getVariables() {
                return vars;
            }
        };
        vars.set("gshell.prompt", this.application.getModel().getBranding().getPrompt());
        vars.set("gshell.group", "/");
        vars.set("gshell.username", this.application.getUserName());
        vars.set("gshell.hostname", this.application.getLocalHost());
        vars.set("gshell.internal.history", this.getHistory(), true);
        this.loadProfileScripts();
        this.opened = true;
    }

    @Override
    public synchronized void close() {
        this.log.debug("Closing");
        this.opened = false;
    }

    @Override
    public ShellContext getContext() {
        this.ensureOpened();
        if (this.context == null) {
            throw new IllegalStateException("Shell context has not been initialized");
        }
        return this.context;
    }

    public void setCompleters(List<Completor> completers) {
        assert (completers != null);
        this.completers = completers;
    }

    public History getHistory() {
        if (this.history == null) {
            throw new IllegalStateException("Missing configuration property: history");
        }
        return this.history;
    }

    public void setHistory(History history) {
        this.history = history;
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public Object execute(String line) throws Exception {
        this.ensureOpened();
        assert (this.executor != null);
        return this.executor.execute(this.getContext(), line);
    }

    @Override
    public Object execute(String command, Object[] args) throws Exception {
        this.ensureOpened();
        assert (this.executor != null);
        return this.executor.execute(this.getContext(), command, args);
    }

    @Override
    public Object execute(Object ... args) throws Exception {
        this.ensureOpened();
        assert (this.executor != null);
        return this.executor.execute(this.getContext(), args);
    }

    @Override
    public void run(Object ... args) throws Exception {
        String message;
        assert (args != null);
        this.ensureOpened();
        this.log.debug("Starting interactive console; args: {}", args);
        this.loadUserScript(this.application.getModel().getBranding().getInteractiveScriptName());
        final AtomicReference exitNotifHolder = new AtomicReference();
        final AtomicReference lastResultHolder = new AtomicReference();
        Console.Executor executor = new Console.Executor(){

            public Console.Executor.Result execute(String line) throws Exception {
                assert (line != null);
                try {
                    Object result = ShellImpl.this.execute(line);
                    lastResultHolder.set(result);
                }
                catch (ExitNotification n) {
                    exitNotifHolder.set(n);
                    return Console.Executor.Result.STOP;
                }
                return Console.Executor.Result.CONTINUE;
            }
        };
        IO io = this.getContext().getIo();
        JLineConsole console = new JLineConsole(executor, io);
        console.setPrompter(this.getPrompter());
        console.setErrorHandler(this.getErrorHandler());
        console.setHistory(this.getHistory());
        if (this.completers != null) {
            console.addCompleter(new AggregateCompleter(this.completers));
        }
        if (!io.isQuiet() && (message = this.application.getModel().getBranding().getWelcomeMessage()) != null) {
            io.out.print(message);
            io.out.println(ShellImpl.repeat("-", io.getTerminal().getTerminalWidth() - 1));
            io.out.flush();
        }
        if (args.length != 0) {
            this.execute(args);
        }
        console.run();
        ExitNotification n = (ExitNotification)exitNotifHolder.get();
        if (n != null) {
            throw n;
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuilder buffer = new StringBuilder(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    public Console.Prompter getPrompter() {
        if (this.prompter == null) {
            throw new IllegalStateException("Missing configuration property: prompter");
        }
        return this.prompter;
    }

    public void setPrompter(Console.Prompter prompter) {
        this.prompter = prompter;
    }

    public Console.ErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            throw new IllegalStateException("Missing configuration property: errorHandler");
        }
        return this.errorHandler;
    }

    public void setErrorHandler(Console.ErrorHandler handler) {
        this.errorHandler = handler;
    }

    private void loadProfileScripts() throws Exception {
        this.log.debug("Loading profile scripts");
        this.loadSharedScript(this.application.getModel().getBranding().getProfileScriptName());
        this.loadUserScript(this.application.getModel().getBranding().getProfileScriptName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadScript(File file) throws Exception {
        assert (file != null);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.execute(line);
            }
        }
        catch (Throwable throwable) {
            Closer.close(reader);
            throw throwable;
        }
        Closer.close(reader);
    }

    private void loadUserScript(String fileName) throws Exception {
        assert (fileName != null);
        File file = new File(this.application.getModel().getBranding().getUserDirectory(), fileName);
        if (file.exists()) {
            this.log.debug("Loading user-script: {}", (Object)file);
            this.loadScript(file);
        } else {
            this.log.debug("User script is not present: {}", (Object)file);
        }
    }

    private void loadSharedScript(String fileName) throws Exception {
        assert (fileName != null);
        File file = new File(this.application.getModel().getBranding().getUserDirectory(), fileName);
        if (file.exists()) {
            this.log.debug("Loading shared-script: {}", (Object)file);
            this.loadScript(file);
        } else {
            this.log.debug("Shared script is not present: {}", (Object)file);
        }
    }
}

