/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.core;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.Properties;
import org.apache.geronimo.gshell.application.Application;
import org.apache.geronimo.gshell.application.ClassPath;
import org.apache.geronimo.gshell.application.model.ApplicationModel;
import org.apache.geronimo.gshell.artifact.Artifact;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.io.IO;
import org.apache.servicemix.kernel.gshell.core.ServiceMixBranding;
import org.springframework.beans.factory.InitializingBean;

public class ApplicationImpl
implements Application,
InitializingBean {
    private static final String EMBEDDED_PROPS = "org/apache/servicemix/kernel/version/embedded.properties";
    private static final String SERVICEMIX_VERSION = "org/apache/servicemix/kernel/gshell/core/servicemix-version.properties";
    private static final String VERSION_PROPERTY = "version";
    private String id;
    private IO io;
    private ApplicationModel model;
    private Variables variables;
    private InetAddress localHost = InetAddress.getLocalHost();
    private File homeDir = this.detectHomeDir();
    private URL embeddedResource = null;

    public void afterPropertiesSet() throws Exception {
        Properties props = new Properties();
        props.load(this.getClass().getClassLoader().getResourceAsStream(SERVICEMIX_VERSION));
        String kernelVersion = props.getProperty(VERSION_PROPERTY);
        this.model.setVersion(kernelVersion);
        ServiceMixBranding smxBranding = (ServiceMixBranding)this.model.getBranding();
        smxBranding.setVersion(kernelVersion);
        if (this.getClass().getClassLoader().getResource(EMBEDDED_PROPS) != null) {
            this.embeddedResource = this.getClass().getClassLoader().getResource(EMBEDDED_PROPS);
            smxBranding.setEmbeddedResource(this.embeddedResource);
        }
    }

    public URL getEmbeddedResource() {
        return this.embeddedResource;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IO getIo() {
        return this.io;
    }

    public void setIo(IO io) {
        this.io = io;
    }

    public Variables getVariables() {
        return this.variables;
    }

    public void setVariables(Variables variables) {
        this.variables = variables;
    }

    public ApplicationModel getModel() {
        return this.model;
    }

    public void setModel(ApplicationModel model) {
        this.model = model;
    }

    public ClassPath getClassPath() {
        throw new UnsupportedOperationException();
    }

    public File getHomeDir() {
        if (this.homeDir == null) {
            throw new IllegalStateException();
        }
        return this.homeDir;
    }

    public InetAddress getLocalHost() {
        return this.localHost;
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    public Artifact getArtifact() {
        return null;
    }

    private File detectHomeDir() {
        File dir;
        String homePath = System.getProperty("user.home");
        try {
            dir = new File(homePath).getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to resolve home directory: " + homePath, e);
        }
        if (!dir.exists() || !dir.isDirectory()) {
            throw new RuntimeException("Home directory configured but is not a valid directory: " + dir);
        }
        return dir;
    }
}

