/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.core;

import org.apache.geronimo.gshell.application.Application;
import org.apache.geronimo.gshell.application.ApplicationConfiguration;
import org.apache.geronimo.gshell.application.ApplicationManager;
import org.apache.geronimo.gshell.event.EventPublisher;
import org.apache.geronimo.gshell.io.SystemOutputHijacker;
import org.apache.geronimo.gshell.shell.Shell;
import org.apache.geronimo.gshell.wisdom.application.ShellCreatedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ApplicationManagerImpl
implements ApplicationManager,
ApplicationContextAware,
InitializingBean,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private EventPublisher eventPublisher;
    private Application application;
    private ApplicationContext applicationContext;

    public ApplicationManagerImpl(EventPublisher eventPublisher, Application application) {
        this.eventPublisher = eventPublisher;
        this.application = application;
    }

    public void afterPropertiesSet() throws Exception {
        if (!SystemOutputHijacker.isInstalled()) {
            SystemOutputHijacker.install();
        }
    }

    public void destroy() {
        SystemOutputHijacker.uninstall();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void configure(ApplicationConfiguration applicationConfiguration) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Application getApplication() {
        return this.application;
    }

    public Shell create() throws Exception {
        Shell shell = (Shell)this.applicationContext.getBean("shell");
        this.log.debug("Created shell instance: {}", (Object)shell);
        this.eventPublisher.publish(new ShellCreatedEvent(shell));
        return shell;
    }
}

