/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.geronimo.gshell.command.CommandContext;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.io.IO;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.context.BundleContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OsgiCommandSupport
implements CommandAction,
BundleContextAware {
    protected Log log = LogFactory.getLog(this.getClass());
    protected BundleContext bundleContext;
    protected CommandContext commandContext;
    protected IO io;
    protected Variables variables;
    protected List<ServiceReference> usedReferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(CommandContext commandContext) throws Exception {
        this.commandContext = commandContext;
        this.io = commandContext.getIo();
        this.variables = commandContext.getVariables();
        try {
            Object object = this.doExecute();
            return object;
        }
        finally {
            this.ungetServices();
        }
    }

    protected abstract Object doExecute() throws Exception;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    protected <T> List<T> getAllServices(Class<T> clazz, String filter) throws Exception {
        ServiceReference[] references = this.getBundleContext().getAllServiceReferences(clazz.getName(), filter);
        if (references == null) {
            return null;
        }
        ArrayList<T> services = new ArrayList<T>();
        for (ServiceReference ref : references) {
            T t = this.getService(clazz, ref);
            services.add(t);
        }
        return services;
    }

    protected <T> T getService(Class<T> clazz, ServiceReference reference) {
        Object t = this.getBundleContext().getService(reference);
        if (t != null) {
            if (this.usedReferences == null) {
                this.usedReferences = new ArrayList<ServiceReference>();
            }
            this.usedReferences.add(reference);
        }
        return (T)t;
    }

    protected void ungetServices() {
        if (this.usedReferences != null) {
            for (ServiceReference ref : this.usedReferences) {
                this.getBundleContext().ungetService(ref);
            }
        }
    }
}

