/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.core.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.gshell.command.Alias;
import org.apache.geronimo.gshell.command.Link;
import org.apache.geronimo.gshell.wisdom.command.AliasImpl;
import org.apache.geronimo.gshell.wisdom.command.ConfigurableCommandCompleter;
import org.apache.geronimo.gshell.wisdom.command.LinkImpl;
import org.apache.geronimo.gshell.wisdom.registry.CommandLocationImpl;
import org.apache.servicemix.kernel.gshell.core.CommandBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CommandParser
extends AbstractBeanDefinitionParser {
    public static final String ID = "id";
    public static final String DESCRIPTION = "description";
    public static final String PLUGIN_TEMPLATE = "pluginTemplate";
    public static final String ACTION = "action";
    public static final String ACTION_ID = "actionId";
    public static final String COMMAND_TEMPLATE_SUFFIX = "CommandTemplate";
    public static final String COMMAND_BUNDLE = "command-bundle";
    public static final String NAME = "name";
    public static final String LOCATION = "location";
    public static final String COMMANDS = "commands";
    public static final String COMMAND = "command";
    public static final String TYPE = "type";
    public static final String DOCUMENTER = "documenter";
    public static final String COMPLETER = "completer";
    public static final String COMPLETERS = "completers";
    public static final String BEAN = "bean";
    public static final String REF = "ref";
    public static final String NULL = "null";
    public static final String MESSAGE_SOURCE = "message-source";
    public static final String MESSAGES = "messages";
    public static final String PROTOTYPE = "prototype";
    public static final String ALIAS = "alias";
    public static final String ALIASES = "aliases";
    public static final String LINK = "link";
    public static final String LINKS = "links";
    public static final String TARGET = "target";

    protected boolean shouldGenerateId() {
        return true;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext context) {
        assert (element != null);
        assert (context != null);
        Builder builder = new Builder(context);
        BeanDefinitionBuilder plugin = builder.parseCommandBundle(element);
        return plugin.getBeanDefinition();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Builder {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private ParserContext context;

        public Builder(ParserContext context) {
            assert (context != null);
            this.context = context;
        }

        private String resolveId(Element element, BeanDefinition def) throws BeanDefinitionStoreException {
            assert (element != null);
            assert (def != null);
            if (CommandParser.this.shouldGenerateId()) {
                return this.context.getReaderContext().generateBeanName(def);
            }
            String id = element.getAttribute(CommandParser.ID);
            if (!StringUtils.hasText((String)id) && CommandParser.this.shouldGenerateIdAsFallback()) {
                id = this.context.getReaderContext().generateBeanName(def);
            }
            return id;
        }

        private List<Element> getChildElements(Element element, String name) {
            assert (element != null);
            assert (name != null);
            return DomUtils.getChildElementsByTagName((Element)element, (String)name);
        }

        private List<Element> getChildElements(Element element, String[] names) {
            assert (element != null);
            assert (names != null);
            return DomUtils.getChildElementsByTagName((Element)element, (String[])names);
        }

        private Element getChildElement(Element element, String name) {
            assert (element != null);
            assert (name != null);
            List elements = DomUtils.getChildElementsByTagName((Element)element, (String)name);
            if (elements != null && !elements.isEmpty()) {
                return (Element)elements.get(0);
            }
            return null;
        }

        private BeanDefinitionParserDelegate createBeanDefinitionParserDelegate(Element element) {
            assert (element != null);
            BeanDefinitionParserDelegate parser = new BeanDefinitionParserDelegate(this.context.getReaderContext());
            parser.initDefaults(element.getOwnerDocument().getDocumentElement());
            return parser;
        }

        private BeanDefinitionHolder parseBeanDefinitionElement(Element element) {
            assert (element != null);
            BeanDefinitionParserDelegate parser = this.createBeanDefinitionParserDelegate(element);
            return parser.parseBeanDefinitionElement(element);
        }

        private void parseAndApplyDescription(Element element, BeanDefinition def) {
            assert (element != null);
            assert (def != null);
            Element desc = this.getChildElement(element, CommandParser.DESCRIPTION);
            if (desc != null && def instanceof AbstractBeanDefinition) {
                ((AbstractBeanDefinition)def).setDescription(desc.getTextContent());
            }
        }

        private void parseAndApplyDescription(Element element, BeanDefinitionBuilder builder) {
            assert (element != null);
            assert (builder != null);
            this.parseAndApplyDescription(element, (BeanDefinition)builder.getRawBeanDefinition());
        }

        private BeanDefinitionHolder register(BeanDefinitionHolder holder) {
            assert (holder != null);
            CommandParser.this.registerBeanDefinition(holder, this.context.getRegistry());
            return holder;
        }

        private BeanDefinitionHolder register(BeanDefinition def, String id) {
            assert (def != null);
            assert (id != null);
            BeanDefinitionHolder holder = new BeanDefinitionHolder(def, id);
            return this.register(holder);
        }

        private BeanDefinitionBuilder parseCommandBundle(Element element) {
            assert (element != null);
            this.log.trace("Parse command bundle; element; {}", (Object)element);
            BeanDefinitionBuilder bundle = BeanDefinitionBuilder.rootBeanDefinition(CommandBundle.class);
            this.parseAndApplyDescription(element, bundle);
            ManagedList commands = new ManagedList();
            commands.addAll(this.parseCommands(element));
            bundle.addPropertyValue(CommandParser.COMMANDS, (Object)commands);
            ManagedList links = new ManagedList();
            links.addAll(this.parseLinks(element));
            bundle.addPropertyValue(CommandParser.LINKS, (Object)links);
            ManagedList aliases = new ManagedList();
            aliases.addAll(this.parseAliases(element));
            bundle.addPropertyValue(CommandParser.ALIASES, (Object)aliases);
            return bundle;
        }

        private List<BeanDefinition> parseCommands(Element element) {
            assert (element != null);
            this.log.trace("Parse commands; element; {}", (Object)element);
            ArrayList<BeanDefinition> commands = new ArrayList<BeanDefinition>();
            List<Element> children = this.getChildElements(element, CommandParser.COMMAND);
            for (Element child : children) {
                BeanDefinitionBuilder command = this.parseCommand(child);
                commands.add((BeanDefinition)command.getBeanDefinition());
            }
            return commands;
        }

        private BeanDefinitionBuilder parseCommand(Element element) {
            BeanDefinitionHolder holder;
            assert (element != null);
            this.log.trace("Parse command; element; {}", (Object)element);
            CommandType type = CommandType.parse(element.getAttribute(CommandParser.TYPE));
            BeanDefinitionBuilder command = BeanDefinitionBuilder.childBeanDefinition((String)type.getTemplateName());
            this.parseAndApplyDescription(element, command);
            String name = element.getAttribute(CommandParser.NAME);
            GenericBeanDefinition def = new GenericBeanDefinition();
            def.setBeanClassName(CommandLocationImpl.class.getName());
            def.getConstructorArgumentValues().addGenericArgumentValue((Object)name);
            command.addPropertyValue(CommandParser.LOCATION, (Object)def);
            Element child = this.getChildElement(element, CommandParser.ACTION);
            BeanDefinitionHolder action = this.parseCommandAction(child);
            type.wire(command, action);
            child = this.getChildElement(element, CommandParser.DOCUMENTER);
            if (child != null) {
                holder = this.parseBeanDefinitionElement(child);
                command.addPropertyValue(CommandParser.DOCUMENTER, (Object)holder.getBeanDefinition());
            }
            if ((child = this.getChildElement(element, CommandParser.COMPLETER)) != null) {
                holder = this.parseBeanDefinitionElement(child);
                command.addPropertyValue(CommandParser.COMPLETER, (Object)holder.getBeanDefinition());
            }
            if ((child = this.getChildElement(element, CommandParser.COMPLETERS)) != null) {
                BeanDefinitionBuilder completer = this.parseCommandCompleters(child);
                command.addPropertyValue(CommandParser.COMPLETER, (Object)completer.getBeanDefinition());
            }
            if ((child = this.getChildElement(element, CommandParser.MESSAGE_SOURCE)) != null) {
                holder = this.parseBeanDefinitionElement(child);
                command.addPropertyValue(CommandParser.MESSAGES, (Object)holder.getBeanDefinition());
            }
            return command;
        }

        private BeanDefinitionBuilder parseCommandCompleters(Element element) {
            assert (element != null);
            BeanDefinitionBuilder completer = BeanDefinitionBuilder.rootBeanDefinition(ConfigurableCommandCompleter.class);
            ManagedList completers = new ManagedList();
            List<Element> children = this.getChildElements(element, new String[]{CommandParser.BEAN, CommandParser.REF, CommandParser.NULL});
            for (Element child : children) {
                if (DomUtils.nodeNameEquals((Node)child, (String)CommandParser.BEAN)) {
                    BeanDefinitionHolder holder = this.parseBeanDefinitionElement(child);
                    completers.add((Object)holder.getBeanDefinition());
                    continue;
                }
                if (DomUtils.nodeNameEquals((Node)child, (String)CommandParser.REF)) {
                    BeanDefinitionParserDelegate parser = this.createBeanDefinitionParserDelegate(child);
                    RuntimeBeanReference ref = (RuntimeBeanReference)parser.parsePropertySubElement(child, (BeanDefinition)completer.getRawBeanDefinition());
                    completers.add((Object)ref);
                    continue;
                }
                if (!DomUtils.nodeNameEquals((Node)child, (String)CommandParser.NULL)) continue;
                completers.add(null);
            }
            completer.addConstructorArgValue((Object)completers);
            return completer;
        }

        private BeanDefinitionHolder parseCommandAction(Element element) {
            assert (element != null);
            this.log.trace("Parse command action; element; {}", (Object)element);
            BeanDefinition action = this.parseBeanDefinitionElement(element).getBeanDefinition();
            action.setScope(CommandParser.PROTOTYPE);
            String id = this.resolveId(element, action);
            return this.register(action, id);
        }

        private List<Link> parseLinks(Element element) {
            assert (element != null);
            this.log.trace("Parse links; element; {}", (Object)element);
            ArrayList<Link> links = new ArrayList<Link>();
            List<Element> children = this.getChildElements(element, CommandParser.LINK);
            for (Element child : children) {
                String name = child.getAttribute(CommandParser.NAME);
                String target = child.getAttribute(CommandParser.TARGET);
                links.add(new LinkImpl(name, target));
            }
            return links;
        }

        private List<Alias> parseAliases(Element element) {
            assert (element != null);
            this.log.trace("Parse aliases; element; {}", (Object)element);
            ArrayList<Alias> aliases = new ArrayList<Alias>();
            List<Element> children = this.getChildElements(element, CommandParser.ALIAS);
            for (Element child : children) {
                String name = child.getAttribute(CommandParser.NAME);
                String alias = child.getAttribute(CommandParser.ALIAS);
                aliases.add(new AliasImpl(name, alias));
            }
            return aliases;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CommandType
    extends Enum<CommandType> {
        public static final /* enum */ CommandType STATELESS = new CommandType();
        public static final /* enum */ CommandType STATEFUL = new CommandType();
        private static final /* synthetic */ CommandType[] $VALUES;

        public static final CommandType[] values() {
            return (CommandType[])$VALUES.clone();
        }

        public static CommandType valueOf(String name) {
            return Enum.valueOf(CommandType.class, name);
        }

        public static CommandType parse(String text) {
            assert (text != null);
            return CommandType.valueOf(text.toUpperCase());
        }

        public String getTemplateName() {
            return this.name().toLowerCase() + CommandParser.COMMAND_TEMPLATE_SUFFIX;
        }

        public void wire(BeanDefinitionBuilder command, BeanDefinitionHolder action) {
            assert (command != null);
            assert (action != null);
            switch (this) {
                case STATELESS: {
                    command.addPropertyReference(CommandParser.ACTION, action.getBeanName());
                    break;
                }
                case STATEFUL: {
                    command.addPropertyValue(CommandParser.ACTION_ID, (Object)action.getBeanName());
                }
            }
        }

        static {
            $VALUES = new CommandType[]{STATELESS, STATEFUL};
        }
    }
}

