/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.ops4j.pax.url.mvn.internal.Settings;
import org.ops4j.util.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsImpl
implements Settings {
    private static final String LOCAL_REPOSITORY_TAG = "localRepository";
    private static final String SERVER_TAG = "servers/server";
    private static final String REPOSITORY_TAG = "repositories/repository";
    private static final String PROXY_TAG = "proxies/proxy";
    private static final String DEFAULT_REPOSITORIES = "http://repo1.maven.org/maven2,http://repository.ops4j.org/maven2,http://repository.springsource.com/maven/bundles/release,http://repository.springsource.com/maven/bundles/external";
    private Document m_document;
    private URL m_settingsURL;
    private String m_localRepository;
    private String m_repositories;
    private Map<String, Map<String, String>> m_proxySettings;

    public SettingsImpl(URL settingsURL) {
        this.m_settingsURL = settingsURL;
        if (this.m_settingsURL == null) {
            this.m_settingsURL = SettingsImpl.safeGetFile(System.getProperty("user.home") + "/.m2/settings.xml");
            if (this.m_settingsURL == null) {
                this.m_settingsURL = SettingsImpl.safeGetFile(System.getProperty("maven.home") + "/conf/settings.xml");
                if (this.m_settingsURL == null) {
                    try {
                        this.m_settingsURL = SettingsImpl.safeGetFile(System.getenv("M2_HOME") + "/conf/settings.xml");
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public String getLocalRepository() {
        if (this.m_localRepository == null) {
            Element settingsElement;
            this.readSettings();
            if (this.m_document != null && (settingsElement = XmlUtils.getElement(this.m_document, LOCAL_REPOSITORY_TAG)) != null) {
                this.m_localRepository = XmlUtils.getTextContent(settingsElement);
            }
            if (this.m_localRepository == null || this.m_localRepository.trim().length() == 0) {
                this.m_localRepository = System.getProperty("user.home") + "/.m2/repository";
            }
        }
        return this.m_localRepository;
    }

    @Override
    public String getRepositories() {
        if (this.m_repositories == null) {
            this.readSettings();
            if (this.m_document != null) {
                HashMap<String, String> repositories = null;
                ArrayList<String> order = null;
                List<Element> repos = XmlUtils.getElements(this.m_document, REPOSITORY_TAG);
                if (repos != null) {
                    for (Element repo : repos) {
                        String url;
                        String id;
                        Element element = XmlUtils.getElement(repo, "id");
                        if (element == null || (id = XmlUtils.getTextContent(element)) == null) continue;
                        element = XmlUtils.getElement(repo, "layout");
                        String layout = null;
                        if (element != null) {
                            layout = XmlUtils.getTextContent(element);
                        }
                        if (layout != null && !"default".equals(layout)) continue;
                        String snapshots = XmlUtils.getTextContentOfElement(repo, "snapshots/enabled");
                        String releases = XmlUtils.getTextContentOfElement(repo, "releases/enabled");
                        element = XmlUtils.getElement(repo, "url");
                        if (element == null || (url = XmlUtils.getTextContent(element)) == null) continue;
                        if (repositories == null) {
                            repositories = new HashMap<String, String>();
                            order = new ArrayList<String>();
                        }
                        if (snapshots != null && Boolean.valueOf(snapshots).booleanValue()) {
                            url = url + "@snapshots";
                        }
                        if (releases != null && !Boolean.valueOf(releases).booleanValue()) {
                            url = url + "@noreleases";
                        }
                        repositories.put(id, url);
                        order.add(id);
                    }
                }
                if (repositories != null) {
                    List<Element> servers = XmlUtils.getElements(this.m_document, SERVER_TAG);
                    if (servers != null) {
                        for (Element server : servers) {
                            String password;
                            String username;
                            String id;
                            String repository;
                            Element element = XmlUtils.getElement(server, "id");
                            if (element == null || (repository = (String)repositories.get(id = XmlUtils.getTextContent(element))) == null || !repository.contains("://") || (element = XmlUtils.getElement(server, "username")) == null || (username = XmlUtils.getTextContent(element)) == null) continue;
                            element = XmlUtils.getElement(server, "password");
                            if (element != null && (password = XmlUtils.getTextContent(element)) != null) {
                                username = username + ":" + password;
                            }
                            repositories.put(id, repository.replaceFirst("://", "://" + username + "@"));
                        }
                    }
                    StringBuilder builder = new StringBuilder();
                    for (String repositoryId : order) {
                        if (builder.length() > 0) {
                            builder.append(",");
                        }
                        builder.append((String)repositories.get(repositoryId));
                    }
                    this.m_repositories = builder.toString();
                }
            }
            this.m_repositories = this.m_repositories == null ? DEFAULT_REPOSITORIES : this.m_repositories + "," + DEFAULT_REPOSITORIES;
        }
        return this.m_repositories;
    }

    private void readSettings() {
        if (this.m_document == null && this.m_settingsURL != null) {
            try {
                this.m_document = XmlUtils.parseDoc(this.m_settingsURL.openStream());
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Could not parse settings [" + this.m_settingsURL + "]", e);
            }
            catch (SAXException e) {
                throw new RuntimeException("Could not parse settings [" + this.m_settingsURL + "]", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse settings [" + this.m_settingsURL + "]", e);
            }
        }
    }

    private static URL safeGetFile(String filePath) {
        File file;
        if (filePath != null && (file = new File(filePath)).exists() && file.canRead() && file.isFile()) {
            try {
                return file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getSetting(Element element, String settingName, String defaultSetting) {
        String setting = XmlUtils.getTextContentOfElement(element, settingName);
        if (setting == null) {
            return defaultSetting;
        }
        return setting;
    }

    @Override
    public Map<String, Map<String, String>> getProxySettings() {
        if (this.m_proxySettings == null) {
            List<Element> proxies;
            this.m_proxySettings = new HashMap<String, Map<String, String>>();
            this.readSettings();
            if (this.m_document != null && (proxies = XmlUtils.getElements(this.m_document, PROXY_TAG)) != null) {
                for (Element proxy : proxies) {
                    String active = this.getSetting(proxy, "active", "false");
                    String protocol = this.getSetting(proxy, "protocol", "http");
                    if (this.m_proxySettings.containsKey(protocol) && !"true".equalsIgnoreCase(active)) continue;
                    HashMap<String, String> proxyDetails = new HashMap<String, String>();
                    proxyDetails.put("user", this.getSetting(proxy, "username", ""));
                    proxyDetails.put("pass", this.getSetting(proxy, "password", ""));
                    proxyDetails.put("host", this.getSetting(proxy, "host", "127.0.0.1"));
                    proxyDetails.put("port", this.getSetting(proxy, "port", "8080"));
                    proxyDetails.put("nonProxyHosts", this.getSetting(proxy, "nonProxyHosts", ""));
                    this.m_proxySettings.put(protocol, proxyDetails);
                }
            }
        }
        return Collections.unmodifiableMap(this.m_proxySettings);
    }
}

