/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.osgi.jmx.codec.Util;
import org.osgi.jmx.core.FrameworkMBean;

public class BundleBatchActionResult {
    public static final CompositeType RESULT = BundleBatchActionResult.createResultType();
    private long bundleInError;
    private long[] completed;
    private String errorMessage;
    private long[] remaining;
    private boolean success = true;

    public BundleBatchActionResult() {
        this.success = true;
    }

    public BundleBatchActionResult(CompositeData compositeData) {
        int i;
        this.errorMessage = (String)compositeData.get("Error");
        Long[] c = (Long[])compositeData.get("Completed");
        this.bundleInError = (Long)compositeData.get("BundleInError");
        if (c != null) {
            this.completed = new long[c.length];
            for (i = 0; i < c.length; ++i) {
                this.completed[i] = c[i];
            }
        } else {
            this.completed = new long[0];
        }
        if ((c = (Long[])compositeData.get("Remaining")) != null) {
            this.remaining = new long[c.length];
            for (i = 0; i < c.length; ++i) {
                this.remaining[i] = c[i];
            }
        } else {
            this.remaining = new long[0];
        }
    }

    public BundleBatchActionResult(String errorMessage, long[] completed, long bundleInError, long[] remaining) {
        this.success = false;
        this.errorMessage = errorMessage;
        this.completed = completed;
        this.bundleInError = bundleInError;
        this.remaining = remaining;
    }

    private static CompositeType createResultType() {
        String description = "This type encapsulates a bundle batch install action result";
        String[] itemNames = FrameworkMBean.BUNDLE_ACTION_RESULT;
        OpenType[] itemTypes = new OpenType[itemNames.length];
        String[] itemDescriptions = new String[itemNames.length];
        itemTypes[0] = SimpleType.BOOLEAN;
        itemTypes[1] = SimpleType.STRING;
        itemTypes[2] = Util.LONG_ARRAY_TYPE;
        itemTypes[3] = SimpleType.LONG;
        itemTypes[4] = Util.LONG_ARRAY_TYPE;
        itemDescriptions[0] = "Whether the operation was successful";
        itemDescriptions[1] = "The error message if unsuccessful";
        itemDescriptions[2] = "The bundle ids of the successfully completed installs";
        itemDescriptions[3] = "The id of the bundle causing the error";
        itemDescriptions[4] = "The ids of the remaining bundles";
        try {
            return new CompositeType("BundleBatchActionResult", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build bundle batch action result type", e);
        }
    }

    public CompositeData asCompositeData() {
        String[] itemNames = FrameworkMBean.BUNDLE_ACTION_RESULT;
        Object[] itemValues = new Object[itemNames.length];
        itemValues[0] = this.success;
        itemValues[1] = this.errorMessage;
        itemValues[2] = Util.LongArrayFrom(this.completed);
        itemValues[3] = this.bundleInError;
        itemValues[4] = Util.LongArrayFrom(this.remaining);
        try {
            return new CompositeDataSupport(RESULT, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form batch result open data", e);
        }
    }

    public long getBundleInError() {
        return this.bundleInError;
    }

    public long[] getCompleted() {
        return this.completed;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long[] getRemaining() {
        return this.remaining;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

