/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.osgi.jmx.codec.Util;
import org.osgi.jmx.core.FrameworkMBean;

public class BundleBatchInstallResult {
    public static final CompositeType BATCH_RESULT = BundleBatchInstallResult.createResultType();
    private String bundleInError;
    private long[] completed;
    private String errorMessage;
    private String[] remaining;
    private boolean success = true;

    public BundleBatchInstallResult(CompositeData compositeData) {
        this.errorMessage = (String)compositeData.get("Error");
        Long[] c = (Long[])compositeData.get("Completed");
        if (c != null) {
            this.completed = new long[c.length];
            for (int i = 0; i < c.length; ++i) {
                this.completed[i] = c[i];
            }
        } else {
            this.completed = new long[0];
        }
        this.bundleInError = (String)compositeData.get("BundleInError");
        this.remaining = (String[])compositeData.get("Remaining");
    }

    public BundleBatchInstallResult(long[] completed) {
        this.success = true;
        this.completed = completed;
    }

    public BundleBatchInstallResult(String errorMessage, long[] completed, String bundleInError, String[] remaining) {
        this.success = false;
        this.errorMessage = errorMessage;
        this.completed = completed;
        this.bundleInError = bundleInError;
        this.remaining = remaining;
    }

    private static CompositeType createResultType() {
        String description = "This type encapsulates a bundle batch install action result";
        String[] itemNames = FrameworkMBean.BUNDLE_ACTION_RESULT;
        OpenType[] itemTypes = new OpenType[itemNames.length];
        String[] itemDescriptions = new String[itemNames.length];
        itemTypes[0] = SimpleType.BOOLEAN;
        itemTypes[1] = SimpleType.STRING;
        itemTypes[2] = Util.LONG_ARRAY_TYPE;
        itemTypes[3] = SimpleType.STRING;
        itemTypes[4] = Util.STRING_ARRAY_TYPE;
        itemDescriptions[0] = "Whether the operation was successful";
        itemDescriptions[1] = "The error message if unsuccessful";
        itemDescriptions[2] = "The bundle ids of the successfully completed installs";
        itemDescriptions[3] = "The location of the bundle causing the error";
        itemDescriptions[4] = "The locations of the remaining bundles";
        try {
            return new CompositeType("BundleBatchInstallResult", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build bundle action result type", e);
        }
    }

    public CompositeData asCompositeData() {
        String[] itemNames = FrameworkMBean.BUNDLE_ACTION_RESULT;
        Object[] itemValues = new Object[itemNames.length];
        itemValues[0] = this.success;
        itemValues[1] = this.errorMessage;
        itemValues[2] = Util.LongArrayFrom(this.completed);
        itemValues[3] = this.bundleInError;
        itemValues[4] = this.remaining;
        try {
            return new CompositeDataSupport(BATCH_RESULT, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form batch result open data", e);
        }
    }

    public String getBundleInError() {
        return this.bundleInError;
    }

    public long[] getCompleted() {
        return this.completed;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String[] getRemaining() {
        return this.remaining;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

