/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.jmx.codec.Util;
import org.osgi.jmx.core.BundleStateMBean;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiBundle {
    private static final String VALUE = "Value";
    private static final String KEY = "Key";
    private static final String[] HEADER_PROPERTY_ITEM_NAMES = new String[]{"Key", "Value"};
    public static final CompositeType BUNDLE_HEADER = OSGiBundle.createBundleHeaderType();
    public static final TabularType BUNDLE_HEADER_TABLE = OSGiBundle.createBundleHeaderTableType();
    public static final CompositeType BUNDLE = OSGiBundle.createBundleType();
    public static final TabularType BUNDLE_TABLE = OSGiBundle.createBundleTableType();
    private String[] exportedPackages;
    private boolean fragment;
    private long[] fragments;
    private Map<String, String> headers;
    private long[] hosts;
    private long identifier;
    private String[] importedPackages;
    private long lastModified;
    private String location;
    private boolean persistentlyStarted;
    private long[] registeredServices;
    private boolean removalPending;
    private boolean required;
    private long[] requiredBundles;
    private long[] requiringBundles;
    private long[] servicesInUse;
    private int startLevel;
    private String state;
    private String symbolicName;

    public OSGiBundle(CompositeData data) {
        this((String)data.get("Location"), (Long)data.get("Identifier"), (String)data.get("BundleSymbolicName"), (Integer)data.get("StartLevel"), (String)data.get("State"), (Long)data.get("LastModified"), (Boolean)data.get("PersistentlyStarted"), (Boolean)data.get("RemovalPending"), (Boolean)data.get("Required"), (Boolean)data.get("Fragment"), Util.longArrayFrom((Long[])data.get("RegisteredServices")), Util.longArrayFrom((Long[])data.get("ServicesInUse")), OSGiBundle.mapFrom((TabularData)data.get("Headers")), (String[])data.get("ExportedPackages"), (String[])data.get("ImportedPackages"), Util.longArrayFrom((Long[])data.get("Fragments")), Util.longArrayFrom((Long[])data.get("Hosts")), Util.longArrayFrom((Long[])data.get("RequiredBundles")), Util.longArrayFrom((Long[])data.get("RequiringBundles")));
    }

    public OSGiBundle(BundleContext bc, PackageAdmin admin, StartLevel sl, Bundle b) {
        this(b.getLocation(), b.getBundleId(), b.getSymbolicName(), sl.getBundleStartLevel(b), Util.getBundleState(b), b.getLastModified(), Util.isBundlePersistentlyStarted(b, sl), Util.isRequiredBundleRemovalPending(b, bc, admin), Util.isBundleRequired(b, bc, admin), Util.isBundleFragment(b, admin), Util.serviceIds(b.getRegisteredServices()), Util.serviceIds(b.getServicesInUse()), Util.getBundleHeaders(b), Util.getBundleExportedPackages(b, admin), Util.getBundleImportedPackages(b, bc, admin), Util.getBundleFragments(b, admin), Util.bundleIds(admin.getHosts(b)), Util.getBundleDependencies(b, admin), Util.getBundlesRequiring(b, bc, admin));
    }

    public OSGiBundle(String location, long identifier, String symbolicName, int startLevel, String state, long lastModified, boolean persistentlyStarted, boolean removalPending, boolean required, boolean fragment, long[] registeredServices, long[] servicesInUse, Map<String, String> headers, String[] exportedPackages, String[] importedPackages, long[] fragments, long[] hosts, long[] requiredBundles, long[] requiringBundles) {
        this.location = location;
        this.identifier = identifier;
        this.symbolicName = symbolicName;
        this.startLevel = startLevel;
        this.state = state;
        this.lastModified = lastModified;
        this.persistentlyStarted = persistentlyStarted;
        this.removalPending = removalPending;
        this.required = required;
        this.fragment = fragment;
        this.registeredServices = registeredServices;
        this.servicesInUse = servicesInUse;
        this.headers = headers;
        this.exportedPackages = exportedPackages;
        this.importedPackages = importedPackages;
        this.fragments = fragments;
        this.hosts = hosts;
        this.requiredBundles = requiredBundles;
        this.requiringBundles = requiringBundles;
    }

    public static TabularData tableFrom(ArrayList<OSGiBundle> bundles) {
        TabularDataSupport table = new TabularDataSupport(BUNDLE_TABLE);
        for (OSGiBundle bundle : bundles) {
            table.put(bundle.asCompositeData());
        }
        return table;
    }

    public static TabularData headerTable(Bundle b) {
        TabularDataSupport table = new TabularDataSupport(BUNDLE_HEADER_TABLE);
        Dictionary map = b.getHeaders();
        Enumeration headers = map.keys();
        while (headers.hasMoreElements()) {
            String key = (String)headers.nextElement();
            table.put(OSGiBundle.headerData(key, (String)map.get(key)));
        }
        return table;
    }

    public static TabularData headerTable(Map<String, String> headers) {
        TabularDataSupport table = new TabularDataSupport(BUNDLE_HEADER_TABLE);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            table.put(OSGiBundle.headerData(entry.getKey(), entry.getValue()));
        }
        return table;
    }

    private static TabularType createBundleTableType() {
        try {
            return new TabularType("Bundles", "The table of all bundles", BUNDLE, new String[]{"Identifier"});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build bundle table type", e);
        }
    }

    private static CompositeType createBundleType() {
        String description = "This type encapsulates OSGi bundles";
        String[] itemNames = BundleStateMBean.BUNDLE;
        OpenType[] itemTypes = new OpenType[itemNames.length];
        String[] itemDescriptions = new String[itemNames.length];
        itemTypes[0] = SimpleType.STRING;
        itemTypes[1] = SimpleType.LONG;
        itemTypes[2] = SimpleType.STRING;
        itemTypes[3] = SimpleType.INTEGER;
        itemTypes[4] = SimpleType.STRING;
        itemTypes[5] = SimpleType.LONG;
        itemTypes[6] = SimpleType.BOOLEAN;
        itemTypes[7] = SimpleType.BOOLEAN;
        itemTypes[8] = SimpleType.BOOLEAN;
        itemTypes[9] = SimpleType.BOOLEAN;
        itemTypes[10] = Util.LONG_ARRAY_TYPE;
        itemTypes[11] = Util.LONG_ARRAY_TYPE;
        itemTypes[12] = BUNDLE_HEADER_TABLE;
        itemTypes[13] = Util.STRING_ARRAY_TYPE;
        itemTypes[14] = Util.STRING_ARRAY_TYPE;
        itemTypes[15] = Util.LONG_ARRAY_TYPE;
        itemTypes[16] = Util.LONG_ARRAY_TYPE;
        itemTypes[17] = Util.LONG_ARRAY_TYPE;
        itemTypes[18] = Util.LONG_ARRAY_TYPE;
        itemDescriptions[0] = "The location of the bundle";
        itemDescriptions[1] = "The id of the bundle";
        itemDescriptions[2] = "The symbolic name of the bundle";
        itemDescriptions[3] = "The start level of the bundle";
        itemDescriptions[4] = "The state of the bundle";
        itemDescriptions[5] = "The last modification time of the bundle";
        itemDescriptions[6] = "Whether the bundle is persistently started";
        itemDescriptions[7] = "Whether the bundle is pending removal";
        itemDescriptions[8] = "Whether the bundle is required";
        itemDescriptions[9] = "Whether the bundle is a fragment";
        itemDescriptions[10] = "The registered services of the bundle";
        itemDescriptions[11] = "The services in use by the bundle";
        itemDescriptions[12] = "The headers of the bundle";
        itemDescriptions[13] = "The exported packages of the bundle";
        itemDescriptions[14] = "The imported packages of the bundle";
        itemDescriptions[15] = "The fragments of which the bundle is host";
        itemDescriptions[16] = "The hosts of the bundle";
        itemDescriptions[17] = "The required bundles the bundle";
        itemDescriptions[18] = "The bundles requiring the bundle";
        try {
            return new CompositeType("Bundle", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build bundle type", e);
        }
    }

    private static CompositeType createBundleHeaderType() {
        String description = "This type encapsulates OSGi bundle header key/value pairs";
        String[] itemNames = HEADER_PROPERTY_ITEM_NAMES;
        OpenType[] itemTypes = new OpenType[itemNames.length];
        String[] itemDescriptions = new String[itemNames.length];
        itemTypes[0] = SimpleType.STRING;
        itemTypes[1] = SimpleType.STRING;
        itemDescriptions[0] = "The bundle header key";
        itemDescriptions[1] = "The bundle header value";
        try {
            return new CompositeType("BundleHeader", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build bundle header type", e);
        }
    }

    private static TabularType createBundleHeaderTableType() {
        try {
            return new TabularType("BundleHeaders", "The table of bundle headers", BUNDLE_HEADER, new String[]{KEY});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Unable to build bundle header table type", e);
        }
    }

    private static CompositeData headerData(String key, String value) {
        Object[] itemValues = new Object[HEADER_PROPERTY_ITEM_NAMES.length];
        itemValues[0] = key;
        itemValues[1] = value;
        try {
            return new CompositeDataSupport(BUNDLE_HEADER, HEADER_PROPERTY_ITEM_NAMES, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle header open data", e);
        }
    }

    public CompositeData asCompositeData() {
        String[] itemNames = BundleStateMBean.BUNDLE;
        Object[] itemValues = new Object[itemNames.length];
        itemValues[0] = this.location;
        itemValues[1] = this.identifier;
        itemValues[2] = this.symbolicName;
        itemValues[3] = this.startLevel;
        itemValues[4] = this.state;
        itemValues[5] = this.lastModified;
        itemValues[6] = this.persistentlyStarted;
        itemValues[7] = this.removalPending;
        itemValues[8] = this.required;
        itemValues[9] = this.fragment;
        itemValues[10] = Util.LongArrayFrom(this.registeredServices);
        itemValues[11] = Util.LongArrayFrom(this.servicesInUse);
        itemValues[12] = OSGiBundle.headerTable(this.headers);
        itemValues[13] = this.exportedPackages;
        itemValues[14] = this.importedPackages;
        itemValues[15] = Util.LongArrayFrom(this.fragments);
        itemValues[16] = Util.LongArrayFrom(this.hosts);
        itemValues[17] = Util.LongArrayFrom(this.requiredBundles);
        itemValues[18] = Util.LongArrayFrom(this.requiringBundles);
        try {
            return new CompositeDataSupport(BUNDLE, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form bundle open data", e);
        }
    }

    public String[] getExportedPackages() {
        return this.exportedPackages;
    }

    public long[] getFragments() {
        return this.fragments;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public long[] getHosts() {
        return this.hosts;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public String[] getImportedPackages() {
        return this.importedPackages;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getLocation() {
        return this.location;
    }

    public long[] getRegisteredServices() {
        return this.registeredServices;
    }

    public long[] getRequiredBundles() {
        return this.requiredBundles;
    }

    public long[] getRequiringBundles() {
        return this.requiringBundles;
    }

    public long[] getServicesInUse() {
        return this.servicesInUse;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public String getState() {
        return this.state;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public boolean isPersistentlyStarted() {
        return this.persistentlyStarted;
    }

    public boolean isRemovalPending() {
        return this.removalPending;
    }

    public boolean isRequired() {
        return this.required;
    }

    private static Map<String, String> mapFrom(TabularData data) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Set<?> keySet = data.keySet();
        for (List key : keySet) {
            headers.put((String)key.get(0), (String)data.get(new Object[]{key.get(0)}).get(VALUE));
        }
        return headers;
    }
}

