/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import java.util.ArrayList;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.osgi.jmx.codec.Util;
import org.osgi.jmx.core.PackageStateMBean;
import org.osgi.service.packageadmin.ExportedPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiPackage {
    public static final CompositeType PACKAGE = OSGiPackage.createPackageType();
    public static final TabularType PACKAGE_TABLE = OSGiPackage.createPackageTableType();
    private long exportingBundle;
    private long[] importingBundles;
    private String name;
    private boolean removalPending;
    private String version;

    public OSGiPackage(CompositeData data) {
        this((String)data.get("Name"), (String)data.get("Version"), (Boolean)data.get("PendingRemoval"), (Long)data.get("BundleIdentifier"), Util.longArrayFrom((Long[])data.get("ImportingBundles")));
    }

    public OSGiPackage(ExportedPackage pkg) {
        this(pkg.getName(), pkg.getVersion().toString(), pkg.isRemovalPending(), pkg.getExportingBundle().getBundleId(), Util.bundleIds(pkg.getImportingBundles()));
    }

    public OSGiPackage(String name, String version, boolean removalPending, long exportingBundle, long[] importingBundles) {
        this.name = name;
        this.version = version;
        this.removalPending = removalPending;
        this.exportingBundle = exportingBundle;
        this.importingBundles = importingBundles;
    }

    public static TabularData tableFrom(ArrayList<OSGiPackage> packages) {
        TabularDataSupport table = new TabularDataSupport(PACKAGE_TABLE);
        for (OSGiPackage pkg : packages) {
            table.put(pkg.asCompositeData());
        }
        return table;
    }

    private static TabularType createPackageTableType() {
        try {
            return new TabularType("Packages", "The table of all packages", PACKAGE, new String[]{"BundleIdentifier", "Name"});
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static CompositeType createPackageType() {
        String description = "This type encapsulates an OSGi package";
        String[] itemNames = PackageStateMBean.PACKAGE;
        OpenType[] itemTypes = new OpenType[itemNames.length];
        String[] itemDescriptions = new String[itemNames.length];
        itemTypes[0] = SimpleType.STRING;
        itemTypes[1] = SimpleType.STRING;
        itemTypes[2] = SimpleType.BOOLEAN;
        itemTypes[3] = SimpleType.LONG;
        itemTypes[4] = Util.LONG_ARRAY_TYPE;
        itemDescriptions[0] = "The package name";
        itemDescriptions[1] = "The package version";
        itemDescriptions[2] = "Whether the package is pending removal";
        itemDescriptions[3] = "The bundle the package belongs to";
        itemDescriptions[4] = "The importing bundles of the package";
        try {
            return new CompositeType("Package", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CompositeData asCompositeData() {
        String[] itemNames = PackageStateMBean.PACKAGE;
        Object[] itemValues = new Object[]{this.name, this.version, this.removalPending, this.exportingBundle, Util.LongArrayFrom(this.importingBundles)};
        try {
            return new CompositeDataSupport(PACKAGE, itemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Cannot form package open data", e);
        }
    }

    public long getExportingBundle() {
        return this.exportingBundle;
    }

    public long[] getImportingBundles() {
        return this.importingBundles;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRemovalPending() {
        return this.removalPending;
    }
}

