/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.jmx.codec;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import org.osgi.jmx.codec.OSGiProperties;
import org.osgi.jmx.codec.OSGiRole;
import org.osgi.jmx.compendium.UserManagerMBean;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiUser {
    protected OSGiRole role;
    protected Hashtable<String, Object> credentials;
    public static final CompositeType USER = OSGiUser.createUserType();

    public OSGiUser(User user) {
        this.role = new OSGiRole((Role)user);
        this.credentials = new Hashtable();
        Dictionary c = user.getCredentials();
        Enumeration keys = c.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.credentials.put(key, c.get(key));
        }
    }

    public OSGiUser(CompositeData data) {
        this.role = new OSGiRole((CompositeData)data.get("Role"));
        this.credentials = OSGiProperties.propertiesFrom((TabularData)data.get("Credentials"));
    }

    public CompositeData asCompositeData() throws OpenDataException {
        String[] itemNames = UserManagerMBean.USER;
        Object[] itemValues = new Object[]{this.role.asCompositeData(), OSGiProperties.tableFrom(this.credentials)};
        return new CompositeDataSupport(USER, itemNames, itemValues);
    }

    private static CompositeType createUserType() {
        String description = "Mapping of org.osgi.service.useradmin.User for remote management purposes. User extends Role";
        String[] itemNames = UserManagerMBean.USER;
        String[] itemDescriptions = new String[]{"The role object that is extended by this user object", "The credentials for this user"};
        OpenType[] itemTypes = new OpenType[]{OSGiRole.ROLE, OSGiProperties.PROPERTY_TABLE};
        try {
            return new CompositeType("User", description, itemNames, itemDescriptions, itemTypes);
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public OSGiRole getRole() {
        return this.role;
    }

    public Map<String, Object> getCredentials() {
        return this.credentials;
    }
}

