/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.naming;

import java.util.Collections;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.xbean.naming.context.ImmutableContext;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.service.ServiceUnavailableException;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;
import org.springframework.util.ClassUtils;

public class OSGiContext
extends ImmutableContext
implements BundleContextAware {
    private final Context services = new OSGiServicesContext();
    private BundleContext bundleContext;

    public OSGiContext() throws NamingException {
        super(Collections.emptyMap());
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Object lookup(String name) throws NamingException {
        if (name.startsWith("osgi:")) {
            if ((name = name.substring(5)).length() == 0) {
                return this;
            }
            if ("services".equals(name)) {
                return this.services;
            }
            if (name.startsWith("services/")) {
                return this.services.lookup(name.substring(9));
            }
            if ("/services".equals(name)) {
                return this.services;
            }
            if (name.startsWith("/services/")) {
                return this.services.lookup(name.substring(10));
            }
            throw new NameNotFoundException("Unrecognized name, does not start with expected 'services': " + name);
        }
        return super.lookup(name);
    }

    public class OSGiServicesContext
    extends ImmutableContext {
        public OSGiServicesContext() throws NamingException {
            super(Collections.emptyMap());
        }

        public Object lookup(String name) throws NamingException {
            String[] parts = name.split("/");
            if (parts.length == 0 || parts.length > 2) {
                throw new NameNotFoundException("Unrecognized name, should be osgi:services:<interface>[/<filter>]");
            }
            String className = parts[0];
            String filter = parts.length == 2 ? parts[1] : null;
            try {
                ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                OsgiServiceProxyFactoryBean factory = new OsgiServiceProxyFactoryBean();
                factory.setBundleContext(OSGiContext.this.getBundleContext());
                factory.setBeanClassLoader(classLoader);
                factory.setFilter(filter);
                factory.setInterfaces(new Class[]{ClassUtils.resolveClassName((String)className, (ClassLoader)classLoader)});
                factory.afterPropertiesSet();
                return factory.getObject();
            }
            catch (ServiceUnavailableException e) {
                NameNotFoundException ex = new NameNotFoundException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }
    }
}

