/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.features.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.kernel.gshell.features.Feature;
import org.apache.servicemix.kernel.gshell.features.FeaturesRegistry;
import org.apache.servicemix.kernel.gshell.features.FeaturesService;
import org.apache.servicemix.kernel.gshell.features.Repository;
import org.apache.servicemix.kernel.gshell.features.internal.FeatureImpl;
import org.apache.servicemix.kernel.gshell.features.internal.RepositoryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;
import org.springframework.osgi.context.BundleContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeaturesServiceImpl
implements FeaturesService,
BundleContextAware {
    private static final String ALIAS_KEY = "_alias_factory_pid";
    private static final Log LOGGER = LogFactory.getLog(FeaturesServiceImpl.class);
    private BundleContext bundleContext;
    private ConfigurationAdmin configAdmin;
    private PreferencesService preferences;
    private Set<URI> uris;
    private Map<URI, RepositoryImpl> repositories = new HashMap<URI, RepositoryImpl>();
    private Map<String, Map<String, Feature>> features;
    private Map<Feature, Set<Long>> installed = new HashMap<Feature, Set<Long>>();
    private String boot;
    private boolean bootFeaturesInstalled;
    private FeaturesRegistry featuresRegistry;
    static Pattern fuzzyVersion = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);
    static Pattern fuzzyModifier = Pattern.compile("(\\d+[.-])*(.*)", 32);

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public PreferencesService getPreferences() {
        return this.preferences;
    }

    public void setPreferences(PreferencesService preferences) {
        this.preferences = preferences;
    }

    public void setFeaturesServiceRegistry(FeaturesRegistry featuresRegistry) {
        this.featuresRegistry = featuresRegistry;
    }

    public void setUrls(String uris) throws URISyntaxException {
        String[] s = uris.split(",");
        this.uris = new HashSet<URI>();
        for (int i = 0; i < s.length; ++i) {
            this.uris.add(new URI(s[i]));
        }
    }

    public void setBoot(String boot) {
        this.boot = boot;
    }

    @Override
    public void addRepository(URI uri) throws Exception {
        if (!this.repositories.values().contains(uri)) {
            this.internalAddRepository(uri);
            this.saveState();
        }
    }

    protected RepositoryImpl internalAddRepository(URI uri) throws Exception {
        RepositoryImpl repo = new RepositoryImpl(uri);
        this.repositories.put(uri, repo);
        this.featuresRegistry.register(repo);
        this.features = null;
        return repo;
    }

    @Override
    public void removeRepository(URI uri) {
        if (this.repositories.containsKey(uri)) {
            this.internalRemoveRepository(uri);
            this.saveState();
        }
    }

    public void internalRemoveRepository(URI uri) {
        this.featuresRegistry.unregister(this.repositories.get(uri));
        this.repositories.remove(uri);
        this.features = null;
    }

    @Override
    public Repository[] listRepositories() {
        Collection<RepositoryImpl> repos = this.repositories.values();
        return repos.toArray(new Repository[repos.size()]);
    }

    public void installAllFeatures(URI uri) throws Exception {
        RepositoryImpl repo = this.internalAddRepository(uri);
        for (Feature f : repo.getFeatures()) {
            this.installFeature(f.getName(), f.getVersion());
        }
        this.internalRemoveRepository(uri);
    }

    public void uninstallAllFeatures(URI uri) throws Exception {
        RepositoryImpl repo = this.internalAddRepository(uri);
        for (Feature f : repo.getFeatures()) {
            this.uninstallFeature(f.getName(), f.getVersion());
        }
        this.internalRemoveRepository(uri);
    }

    @Override
    public void installFeature(String name) throws Exception {
        this.installFeature(name, FeatureImpl.DEFAULT_VERSION);
    }

    @Override
    public void installFeature(String name, String version) throws Exception {
        Feature f = this.getFeature(name, version);
        if (f == null) {
            throw new Exception("No feature named '" + name + "' with version '" + version + "' available");
        }
        for (Feature dependency : f.getDependencies()) {
            this.installFeature(dependency.getName(), dependency.getVersion());
        }
        for (String config : f.getConfigurations().keySet()) {
            Configuration cfg;
            Hashtable<String, String> props = new Hashtable<String, String>(f.getConfigurations().get(config));
            String[] pid = this.parsePid(config);
            if (pid[1] != null) {
                ((Dictionary)props).put(ALIAS_KEY, pid[1]);
            }
            if ((cfg = this.getConfiguration(this.configAdmin, pid[0], pid[1])).getBundleLocation() != null) {
                cfg.setBundleLocation(null);
            }
            cfg.update(props);
        }
        HashSet<Long> bundles = new HashSet<Long>();
        for (String bundleLocation : f.getBundles()) {
            Bundle b = this.installBundleIfNeeded(bundleLocation);
            bundles.add(b.getBundleId());
        }
        Iterator<String> i$ = bundles.iterator();
        while (i$.hasNext()) {
            long id = (Long)((Object)i$.next());
            this.bundleContext.getBundle(id).start();
        }
        this.featuresRegistry.registerInstalled(f);
        this.installed.put(f, bundles);
        this.saveState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle installBundleIfNeeded(String bundleLocation) throws IOException, BundleException {
        LOGGER.debug((Object)("Checking " + bundleLocation));
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new URL(bundleLocation).openStream());
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)e.getMessage());
            throw e;
        }
        try {
            ((InputStream)is).mark(262144);
            JarInputStream jar = new JarInputStream(is);
            Manifest m = jar.getManifest();
            String sn = m.getMainAttributes().getValue("Bundle-SymbolicName");
            String vStr = m.getMainAttributes().getValue("Bundle-Version");
            Version v = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
            for (Bundle b : this.bundleContext.getBundles()) {
                Version bv;
                if (b.getSymbolicName() == null || !b.getSymbolicName().equals(sn)) continue;
                vStr = (String)b.getHeaders().get("Bundle-Version");
                Version version = bv = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
                if (!v.equals((Object)bv)) continue;
                LOGGER.debug((Object)("  found installed bundle: " + b));
                Bundle bundle = b;
                return bundle;
            }
            try {
                ((InputStream)is).reset();
            }
            catch (IOException e) {
                ((InputStream)is).close();
                is = new BufferedInputStream(new URL(bundleLocation).openStream());
            }
            LOGGER.debug((Object)("Installing bundle " + bundleLocation));
            Bundle bundle = this.getBundleContext().installBundle(bundleLocation, (InputStream)is);
            return bundle;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    @Override
    public void uninstallFeature(String name) throws Exception {
        ArrayList<String> versions = new ArrayList<String>();
        for (Feature f : this.installed.keySet()) {
            if (!name.equals(f.getName())) continue;
            versions.add(f.getVersion());
        }
        if (versions.size() == 0) {
            throw new Exception("Feature named '" + name + "' is not installed");
        }
        if (versions.size() > 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("Feature named '" + name + "' has multiple versions installed (");
            for (int i = 0; i < versions.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append((String)versions.get(i));
            }
            sb.append("). Please specify the version to uninstall.");
            throw new Exception(sb.toString());
        }
        this.uninstallFeature(name, (String)versions.get(0));
    }

    @Override
    public void uninstallFeature(String name, String version) throws Exception {
        Feature feature = this.getFeature(name, version);
        if (feature == null || !this.installed.containsKey(feature)) {
            throw new Exception("Feature named '" + name + "' with version '" + version + "' is not installed");
        }
        Set<Long> bundles = this.installed.remove(feature);
        for (Set<Long> b : this.installed.values()) {
            bundles.removeAll(b);
        }
        Iterator<Object> i$ = bundles.iterator();
        while (i$.hasNext()) {
            long bundleId = (Long)i$.next();
            this.getBundleContext().getBundle(bundleId).uninstall();
        }
        this.featuresRegistry.unregisterInstalled(feature);
        this.saveState();
    }

    @Override
    public String[] listFeatures() throws Exception {
        ArrayList<String> features = new ArrayList<String>();
        for (Map<String, Feature> featureWithDifferentVersion : this.getFeatures().values()) {
            for (Feature f : featureWithDifferentVersion.values()) {
                String installStatus = this.installed.containsKey(f) ? "installed  " : "uninstalled";
                String version = f.getVersion();
                switch (version.length()) {
                    case 1: {
                        version = "       " + version;
                    }
                    case 2: {
                        version = "      " + version;
                    }
                    case 3: {
                        version = "     " + version;
                    }
                    case 4: {
                        version = "    " + version;
                    }
                    case 5: {
                        version = "   " + version;
                    }
                    case 6: {
                        version = "  " + version;
                    }
                    case 7: {
                        version = " " + version;
                    }
                }
                features.add("[" + installStatus + "] " + " [" + version + "] " + f.getName());
            }
        }
        return features.toArray(new String[features.size()]);
    }

    @Override
    public String[] listInstalledFeatures() {
        ArrayList<String> result = new ArrayList<String>();
        for (Feature feature : this.installed.keySet()) {
            result.add(feature.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    protected Feature getFeature(String name, String version) throws Exception {
        Map<String, Feature> versions = this.getFeatures().get(name);
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        Feature feature = versions.get(version);
        if (feature == null && FeatureImpl.DEFAULT_VERSION.equals(version)) {
            Version latest = new Version(FeaturesServiceImpl.cleanupVersion(version));
            for (String available : versions.keySet()) {
                Version availableVersion = new Version(FeaturesServiceImpl.cleanupVersion(available));
                if (availableVersion.compareTo((Object)latest) <= 0) continue;
                feature = versions.get(available);
                latest = availableVersion;
            }
        }
        return feature;
    }

    protected Map<String, Map<String, Feature>> getFeatures() throws Exception {
        if (this.features == null) {
            boolean newRepo;
            HashMap<String, Map<String, Feature>> map = new HashMap<String, Map<String, Feature>>();
            do {
                newRepo = false;
                for (Repository repo : this.listRepositories()) {
                    for (URI uri : repo.getRepositories()) {
                        if (this.repositories.keySet().contains(uri)) continue;
                        this.internalAddRepository(uri);
                        newRepo = true;
                    }
                }
            } while (newRepo);
            for (RepositoryImpl repo : this.repositories.values()) {
                for (Feature f : repo.getFeatures()) {
                    if (map.get(f.getName()) == null) {
                        HashMap<String, Feature> versionMap = new HashMap<String, Feature>();
                        versionMap.put(f.getVersion(), f);
                        map.put(f.getName(), versionMap);
                        continue;
                    }
                    ((Map)map.get(f.getName())).put(f.getVersion(), f);
                }
            }
            this.features = map;
        }
        return this.features;
    }

    public void start() throws Exception {
        if (!this.loadState()) {
            if (this.uris != null) {
                for (URI uri : this.uris) {
                    this.internalAddRepository(uri);
                }
            }
            this.saveState();
        }
        if (this.boot != null && !this.bootFeaturesInstalled) {
            new Thread(){

                public void run() {
                    String[] list;
                    for (String f : list = FeaturesServiceImpl.this.boot.split(",")) {
                        if (f.length() <= 0) continue;
                        try {
                            FeaturesServiceImpl.this.installFeature(f);
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)("Error installing boot feature " + f), (Throwable)e);
                        }
                    }
                    FeaturesServiceImpl.this.bootFeaturesInstalled = true;
                    FeaturesServiceImpl.this.saveState();
                }
            }.start();
        }
    }

    public void stop() throws Exception {
        this.uris = new HashSet<URI>(this.repositories.keySet());
        while (!this.repositories.isEmpty()) {
            this.internalRemoveRepository(this.repositories.keySet().iterator().next());
        }
    }

    protected String[] parsePid(String pid) {
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    protected Configuration getConfiguration(ConfigurationAdmin configurationAdmin, String pid, String factoryPid) throws IOException, InvalidSyntaxException {
        if (factoryPid != null) {
            Configuration[] configs = configurationAdmin.listConfigurations("(|(_alias_factory_pid=" + pid + ")(.alias_factory_pid=" + factoryPid + "))");
            if (configs == null || configs.length == 0) {
                return configurationAdmin.createFactoryConfiguration(pid, null);
            }
            return configs[0];
        }
        return configurationAdmin.getConfiguration(pid, null);
    }

    protected void saveState() {
        try {
            Preferences prefs = this.preferences.getUserPreferences("FeaturesServiceState");
            this.saveSet(prefs.node("repositories"), this.repositories.keySet());
            this.saveMap(prefs.node("features"), this.installed);
            prefs.putBoolean("bootFeaturesInstalled", this.bootFeaturesInstalled);
            prefs.flush();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error persisting FeaturesService state", (Throwable)e);
        }
    }

    protected boolean loadState() {
        try {
            Preferences prefs = this.preferences.getUserPreferences("FeaturesServiceState");
            if (prefs.nodeExists("repositories")) {
                Set<URI> repositories = this.loadSet(prefs.node("repositories"));
                for (URI repo : repositories) {
                    this.internalAddRepository(repo);
                }
                this.installed = this.loadMap(prefs.node("features"));
                for (Feature f : this.installed.keySet()) {
                    this.featuresRegistry.registerInstalled(f);
                }
                this.bootFeaturesInstalled = prefs.getBoolean("bootFeaturesInstalled", false);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error loading FeaturesService state", (Throwable)e);
        }
        return false;
    }

    protected void saveSet(Preferences node, Set<URI> set) throws BackingStoreException {
        ArrayList<URI> l = new ArrayList<URI>(set);
        node.clear();
        node.putInt("count", l.size());
        for (int i = 0; i < l.size(); ++i) {
            node.put("item." + i, ((URI)l.get(i)).toString());
        }
    }

    protected Set<URI> loadSet(Preferences node) {
        HashSet<URI> l = new HashSet<URI>();
        int count = node.getInt("count", 0);
        for (int i = 0; i < count; ++i) {
            l.add(URI.create(node.get("item." + i, null)));
        }
        return l;
    }

    protected void saveMap(Preferences node, Map<Feature, Set<Long>> map) throws BackingStoreException {
        node.clear();
        for (Map.Entry<Feature, Set<Long>> entry : map.entrySet()) {
            Feature key = entry.getKey();
            String val = this.createValue(entry.getValue());
            node.put(key.toString(), val);
        }
    }

    protected Map<Feature, Set<Long>> loadMap(Preferences node) throws BackingStoreException {
        HashMap<Feature, Set<Long>> map = new HashMap<Feature, Set<Long>>();
        for (String key : node.keys()) {
            String val = node.get(key, null);
            Set<Long> set = this.readValue(val);
            map.put(FeatureImpl.valueOf(key), set);
        }
        return map;
    }

    protected String createValue(Set<Long> set) {
        StringBuilder sb = new StringBuilder();
        for (long i : set) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(i);
        }
        return sb.toString();
    }

    protected Set<Long> readValue(String val) {
        HashSet<Long> set = new HashSet<Long>();
        for (String str : val.split(",")) {
            set.add(Long.parseLong(str));
        }
        return set;
    }

    public static String cleanupVersion(String version) {
        Matcher m = fuzzyVersion.matcher(version);
        if (m.matches()) {
            StringBuffer result = new StringBuffer();
            String d1 = m.group(1);
            String d2 = m.group(3);
            String d3 = m.group(5);
            String qualifier = m.group(7);
            if (d1 != null) {
                result.append(d1);
                if (d2 != null) {
                    result.append(".");
                    result.append(d2);
                    if (d3 != null) {
                        result.append(".");
                        result.append(d3);
                        if (qualifier != null) {
                            result.append(".");
                            FeaturesServiceImpl.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        FeaturesServiceImpl.cleanupModifier(result, qualifier);
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    FeaturesServiceImpl.cleanupModifier(result, qualifier);
                }
                return result.toString();
            }
        }
        return version;
    }

    static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = fuzzyModifier.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(2);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }
}

