/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.features.management;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.servicemix.kernel.gshell.features.FeaturesRegistry;
import org.apache.servicemix.kernel.gshell.features.management.ManagedFeature;
import org.apache.servicemix.kernel.gshell.features.management.ManagedRepository;
import org.apache.servicemix.kernel.gshell.features.management.NamingStrategy;

public class DefaultNamingStrategy
implements NamingStrategy {
    private String jmxDomainName;

    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    public ObjectName getObjectName(ManagedFeature feature) throws MalformedObjectNameException {
        return this.getObjectName(feature, false);
    }

    public ObjectName getObjectName(ManagedFeature feature, boolean installed) throws MalformedObjectNameException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.jmxDomainName).append(":Service=Features,");
        if (installed) {
            sb.append("Type=Installed,");
        } else {
            sb.append("Type=Available,");
        }
        sb.append("Name=").append(this.sanitize(feature.getName())).append(",").append("FeatureVersion=").append(this.sanitize(feature.getVersion()));
        return new ObjectName(sb.toString());
    }

    public ObjectName getObjectName(ManagedRepository repository) throws MalformedObjectNameException {
        return new ObjectName(this.jmxDomainName + ":" + "Service=Features," + "Type=Repositories," + "Name=" + this.sanitize(repository.getUri().toString()));
    }

    public ObjectName getObjectName(FeaturesRegistry featuresRegistry) throws MalformedObjectNameException {
        return new ObjectName(this.jmxDomainName + ":" + "Service=Features," + "Name=FeaturesService");
    }

    private String sanitize(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
            result = result.replace('?', '_');
            result = result.replace('=', '_');
            result = result.replace(',', '_');
        }
        return result;
    }
}

