/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.features.management;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.kernel.gshell.features.Feature;
import org.apache.servicemix.kernel.gshell.features.FeaturesRegistry;
import org.apache.servicemix.kernel.gshell.features.FeaturesService;
import org.apache.servicemix.kernel.gshell.features.Repository;
import org.apache.servicemix.kernel.gshell.features.management.ManagedFeature;
import org.apache.servicemix.kernel.gshell.features.management.ManagedRepository;
import org.apache.servicemix.kernel.gshell.features.management.ManagementAgent;
import org.apache.servicemix.kernel.gshell.features.management.NamingStrategy;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(description="Features Service Registry and Management")
public class ManagedFeaturesRegistry
implements InitializingBean,
FeaturesRegistry {
    private static final transient Log LOG = LogFactory.getLog(ManagedFeaturesRegistry.class);
    private NamingStrategy namingStrategy;
    private ManagementAgent managementAgent;
    private Map<String, ManagedFeature> availableFeatures = new ConcurrentHashMap<String, ManagedFeature>();
    private Map<String, ManagedFeature> installedFeatures = new ConcurrentHashMap<String, ManagedFeature>();
    private Map<String, ManagedRepository> repositories = new ConcurrentHashMap<String, ManagedRepository>();
    private boolean mbeanServerInitialized;
    private FeaturesService featuresService;
    private MBeanServer mbeanServer;

    @ManagedOperation
    public void installFeature(String name) throws Exception {
        this.featuresService.installFeature(name);
    }

    @ManagedOperation
    public void installFeature(String name, String version) throws Exception {
        this.featuresService.installFeature(name, version);
    }

    @ManagedOperation
    public void installRepository(String repositoryUri) throws Exception {
        this.featuresService.addRepository(new URI(repositoryUri));
    }

    public Map<String, ManagedFeature> getAvailableFeatures() {
        return this.availableFeatures;
    }

    public Map<String, ManagedFeature> getInstalledFeatures() {
        return this.installedFeatures;
    }

    public Map<String, ManagedRepository> getRepositories() {
        return this.repositories;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void setManagementAgent(ManagementAgent managementAgent) {
        this.managementAgent = managementAgent;
    }

    @Override
    public void register(Feature feature) {
        try {
            ManagedFeature mf = new ManagedFeature(feature, this.featuresService);
            this.availableFeatures.put(feature.getId(), mf);
            if (this.mbeanServerInitialized) {
                this.managementAgent.register(mf, this.namingStrategy.getObjectName(mf));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to register managed feature: " + e), (Throwable)e);
        }
    }

    @Override
    public void unregister(Feature feature) {
        try {
            ManagedFeature mf = this.availableFeatures.remove(feature.getId());
            if (this.mbeanServerInitialized) {
                this.managementAgent.unregister(this.namingStrategy.getObjectName(mf));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to unregister managed feature: " + e), (Throwable)e);
        }
    }

    @Override
    public void registerInstalled(Feature feature) {
        try {
            ManagedFeature mf = new ManagedFeature(feature, this.featuresService);
            this.installedFeatures.put(feature.getId(), mf);
            if (this.mbeanServerInitialized) {
                this.managementAgent.register(mf, this.namingStrategy.getObjectName(mf, true));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to register managed feature: " + e), (Throwable)e);
        }
    }

    @Override
    public void unregisterInstalled(Feature feature) {
        try {
            ManagedFeature mf = this.installedFeatures.remove(feature.getId());
            if (this.mbeanServerInitialized) {
                this.managementAgent.unregister(this.namingStrategy.getObjectName(mf, true));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to unregister managed feature: " + e), (Throwable)e);
        }
    }

    @Override
    public void register(Repository repository) {
        try {
            ManagedRepository mr = new ManagedRepository(repository, this.featuresService);
            this.repositories.put(repository.getURI().toString(), mr);
            for (Feature f : repository.getFeatures()) {
                this.register(f);
            }
            if (this.mbeanServerInitialized) {
                this.managementAgent.register(mr, this.namingStrategy.getObjectName(mr));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to register managed repository: " + e), (Throwable)e);
        }
    }

    @Override
    public void unregister(Repository repository) {
        try {
            ManagedRepository mr = this.repositories.remove(repository.getURI().toString());
            for (Feature f : repository.getFeatures()) {
                this.unregister(f);
            }
            if (this.mbeanServerInitialized) {
                this.managementAgent.unregister(this.namingStrategy.getObjectName(mr));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to unregister managed repository: " + e), (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.managementAgent == null) {
            throw new IllegalArgumentException("managementAgent must not be null");
        }
        if (this.namingStrategy == null) {
            throw new IllegalArgumentException("namingStrategy must not be null");
        }
        if (this.mbeanServer != null) {
            this.registerMBeans();
        }
    }

    public void registerMBeanServer(MBeanServer mbeanServer, Map props) throws Exception {
        if (mbeanServer != null) {
            this.mbeanServer = mbeanServer;
            if (this.managementAgent != null && this.namingStrategy != null) {
                this.registerMBeans();
            }
        }
    }

    protected void registerMBeans() throws MalformedObjectNameException, JMException {
        this.mbeanServerInitialized = true;
        this.managementAgent.register(this, this.namingStrategy.getObjectName(this));
        for (ManagedRepository repository : this.repositories.values()) {
            this.managementAgent.register(repository, this.namingStrategy.getObjectName(repository));
        }
        for (ManagedFeature feature : this.availableFeatures.values()) {
            this.managementAgent.register(feature, this.namingStrategy.getObjectName(feature));
        }
        for (ManagedFeature feature : this.installedFeatures.values()) {
            this.installedFeatures.put(feature.getId(), feature);
            this.managementAgent.register(feature, this.namingStrategy.getObjectName(feature, true));
        }
    }
}

