/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.log;

import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.servicemix.kernel.gshell.core.OsgiCommandSupport;
import org.apache.servicemix.kernel.gshell.log.LruList;
import org.apache.servicemix.kernel.gshell.log.layout.PatternConverter;
import org.apache.servicemix.kernel.gshell.log.layout.PatternParser;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayLog
extends OsgiCommandSupport {
    @Option(name="-n", description="Number of entries to display")
    protected int entries;
    @Option(name="-p", description="Output formatting pattern")
    protected String overridenPattern;
    protected String pattern;
    protected LruList<PaxLoggingEvent> events;

    public LruList<PaxLoggingEvent> getEvents() {
        return this.events;
    }

    public void setEvents(LruList<PaxLoggingEvent> events) {
        this.events = events;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    protected Object doExecute() throws Exception {
        PatternConverter cnv = new PatternParser(this.overridenPattern != null ? this.overridenPattern : this.pattern).parse();
        Iterable<PaxLoggingEvent> le = this.events.getElements(this.entries == 0 ? Integer.MAX_VALUE : this.entries);
        StringBuffer sb = new StringBuffer();
        for (PaxLoggingEvent event : le) {
            sb.setLength(0);
            PatternConverter pc = cnv;
            while (pc != null) {
                pc.format(sb, event);
                pc = pc.next;
            }
            this.io.out.print(sb.toString());
            if (event.getThrowableStrRep() == null) continue;
            for (String r : event.getThrowableStrRep()) {
                this.io.out.println(r);
            }
        }
        this.io.out.println();
        return CommandAction.Result.SUCCESS;
    }
}

