/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.log;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LruList<E> {
    private E[] elements;
    private transient int start = 0;
    private transient int end = 0;
    private transient boolean full = false;
    private final int maxElements;

    public LruList(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.elements = new Object[size];
        this.maxElements = this.elements.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        E[] EArray = this.elements;
        synchronized (this.elements) {
            int size = 0;
            size = this.end < this.start ? this.maxElements - this.start + this.end : (this.end == this.start ? (this.full ? this.maxElements : 0) : this.end - this.start);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E element) {
        E[] EArray = this.elements;
        synchronized (this.elements) {
            E e;
            if (null == element) {
                throw new NullPointerException("Attempted to add null object to buffer");
            }
            if (this.size() == this.maxElements && null != (e = this.elements[this.start])) {
                this.elements[this.start++] = null;
                if (this.start >= this.maxElements) {
                    this.start = 0;
                }
                this.full = false;
            }
            this.elements[this.end++] = element;
            if (this.end >= this.maxElements) {
                this.end = 0;
            }
            if (this.end == this.start) {
                this.full = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<E> getElements() {
        E[] EArray = this.elements;
        synchronized (this.elements) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getElements(this.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<E> getElements(int nb) {
        E[] EArray = this.elements;
        synchronized (this.elements) {
            int s = this.size();
            nb = Math.min(Math.max(0, nb), s);
            Object[] e = new Object[nb];
            for (int i = 0; i < nb; ++i) {
                e[i] = this.elements[(i + s - nb + this.start) % this.maxElements];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Arrays.asList(e);
        }
    }
}

