/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.admin.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gshell.shell.ShellContext;
import org.apache.geronimo.gshell.shell.ShellContextHolder;
import org.apache.servicemix.kernel.gshell.admin.AdminService;
import org.apache.servicemix.kernel.gshell.admin.Instance;
import org.apache.servicemix.kernel.gshell.admin.internal.InstanceImpl;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminServiceImpl
implements AdminService,
InitializingBean {
    private static final Log LOGGER = LogFactory.getLog(AdminServiceImpl.class);
    private PreferencesService preferences;
    private Map<String, Instance> instances = new HashMap<String, Instance>();
    private int defaultPortStart = 8101;

    public PreferencesService getPreferences() {
        return this.preferences;
    }

    public void setPreferences(PreferencesService preferences) {
        this.preferences = preferences;
    }

    public synchronized void afterPropertiesSet() throws Exception {
        try {
            Preferences prefs = this.preferences.getUserPreferences("AdminServiceState");
            Preferences child = prefs.node("Instances");
            int count = child.getInt("count", 0);
            HashMap<String, Instance> newInstances = new HashMap<String, Instance>();
            for (int i = 0; i < count; ++i) {
                String name = child.get("item." + i + ".name", null);
                String loc = child.get("item." + i + ".loc", null);
                int pid = child.getInt("item." + i + ".pid", 0);
                if (name == null) continue;
                InstanceImpl instance = new InstanceImpl(this, name, loc);
                if (pid > 0) {
                    try {
                        instance.attach(pid);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                newInstances.put(name, instance);
            }
            this.instances = newInstances;
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unable to reload ServiceMix instance list", (Throwable)e);
        }
    }

    @Override
    public synchronized Instance createInstance(String name, int port, String location) throws Exception {
        if (this.instances.get(name) != null) {
            throw new IllegalArgumentException("Instance '" + name + "' already exists");
        }
        File serviceMixBase = new File(location != null ? location : "instances/" + name).getCanonicalFile();
        int sshPort = port;
        if (sshPort <= 0) {
            try {
                Preferences prefs = this.preferences.getUserPreferences("AdminServiceState");
                sshPort = prefs.getInt("port", this.defaultPortStart + 1);
                prefs.putInt("port", sshPort + 1);
                prefs.flush();
                prefs.sync();
            }
            catch (Exception e) {
                try {
                    ServerSocket ss = new ServerSocket(0);
                    sshPort = ss.getLocalPort();
                    ss.close();
                }
                catch (Exception t) {
                    // empty catch block
                }
            }
            if (sshPort <= 0) {
                sshPort = this.defaultPortStart;
            }
        }
        this.println("Creating new instance on port " + sshPort + " at: @|bold " + serviceMixBase + "|");
        this.mkdir(serviceMixBase, "bin");
        this.mkdir(serviceMixBase, "etc");
        this.mkdir(serviceMixBase, "system");
        this.mkdir(serviceMixBase, "deploy");
        this.mkdir(serviceMixBase, "data");
        this.copyResourceToDir(serviceMixBase, "etc/config.properties", true);
        this.copyResourceToDir(serviceMixBase, "etc/org.apache.servicemix.features.cfg", true);
        this.copyResourceToDir(serviceMixBase, "etc/users.properties", true);
        this.copyResourceToDir(serviceMixBase, "etc/org.ops4j.pax.logging.cfg", true);
        this.copyResourceToDir(serviceMixBase, "etc/org.ops4j.pax.url.mvn.cfg", true);
        this.copyResourceToDir(serviceMixBase, "etc/startup.properties", true);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("${servicemix.name}", name);
        props.put("${servicemix.home}", System.getProperty("servicemix.home"));
        props.put("${servicemix.base}", serviceMixBase.getPath());
        props.put("${servicemix.sshPort}", Integer.toString(sshPort));
        this.copyFilteredResourceToDir(serviceMixBase, "etc/system.properties", props);
        this.copyFilteredResourceToDir(serviceMixBase, "etc/org.apache.servicemix.shell.cfg", props);
        if (System.getProperty("os.name").startsWith("Win")) {
            this.copyFilteredResourceToDir(serviceMixBase, "bin/servicemix.bat", props);
        } else {
            this.copyFilteredResourceToDir(serviceMixBase, "bin/servicemix", props);
            this.chmod(new File(serviceMixBase, "bin/servicemix"), "a+x");
        }
        InstanceImpl instance = new InstanceImpl(this, name, serviceMixBase.toString());
        this.instances.put(name, instance);
        this.saveState();
        return instance;
    }

    @Override
    public synchronized Instance[] getInstances() {
        return this.instances.values().toArray(new Instance[0]);
    }

    @Override
    public synchronized Instance getInstance(String name) {
        return this.instances.get(name);
    }

    synchronized void forget(String name) {
        this.instances.remove(name);
    }

    synchronized void saveState() throws IOException, BackingStoreException {
        Preferences prefs = this.preferences.getUserPreferences("AdminServiceState");
        Preferences child = prefs.node("Instances");
        child.clear();
        Instance[] data = this.getInstances();
        child.putInt("count", data.length);
        for (int i = 0; i < data.length; ++i) {
            child.put("item." + i + ".name", data[i].getName());
            child.put("item." + i + ".loc", data[i].getLocation());
            child.putInt("item." + i + ".pid", data[i].getPid());
        }
        prefs.flush();
        prefs.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceToDir(File target, String resource, boolean text) throws Exception {
        block13: {
            File outFile = new File(target, resource);
            if (!outFile.exists()) {
                this.println("Creating file: @|bold " + outFile.getPath() + "|");
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("/org/apache/servicemix/kernel/gshell/admin/" + resource);
                try {
                    if (text) {
                        PrintStream out = new PrintStream(new FileOutputStream(outFile));
                        try {
                            Scanner scanner = new Scanner(is);
                            while (scanner.hasNextLine()) {
                                String line = scanner.nextLine();
                                out.println(line);
                            }
                            break block13;
                        }
                        finally {
                            this.safeClose(out);
                        }
                    }
                    FileOutputStream out = new FileOutputStream(new File(target, resource));
                    try {
                        int c = 0;
                        while ((c = is.read()) >= 0) {
                            out.write(c);
                        }
                    }
                    finally {
                        this.safeClose(out);
                    }
                }
                finally {
                    this.safeClose(is);
                }
            }
        }
    }

    private void println(String st) {
        ShellContext ctx = ShellContextHolder.get((boolean)true);
        if (ctx != null) {
            ctx.getIo().out.println(st);
        } else {
            System.out.println(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFilteredResourceToDir(File target, String resource, HashMap<String, String> props) throws Exception {
        File outFile = new File(target, resource);
        if (!outFile.exists()) {
            this.println("Creating file: @|bold " + outFile.getPath() + "|");
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("/org/apache/servicemix/kernel/gshell/admin/" + resource);
            try {
                PrintStream out = new PrintStream(new FileOutputStream(outFile));
                try {
                    Scanner scanner = new Scanner(is);
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        line = this.filter(line, props);
                        out.println(line);
                    }
                }
                finally {
                    this.safeClose(out);
                }
            }
            finally {
                this.safeClose(is);
            }
        }
    }

    private void safeClose(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void safeClose(OutputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String filter(String line, HashMap<String, String> props) {
        for (Map.Entry<String, String> i : props.entrySet()) {
            int p1 = line.indexOf(i.getKey());
            if (p1 < 0) continue;
            String l1 = line.substring(0, p1);
            String l2 = line.substring(p1 + i.getKey().length());
            line = l1 + i.getValue() + l2;
        }
        return line;
    }

    private void mkdir(File serviceMixBase, String path) {
        File file = new File(serviceMixBase, path);
        if (!file.exists()) {
            this.println("Creating dir:  @|bold " + file.getPath() + "|");
            file.mkdirs();
        }
    }

    private int chmod(File serviceFile, String mode) throws Exception {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("chmod", mode, serviceFile.getCanonicalPath());
        Process p = builder.start();
        int status = p.waitFor();
        return status;
    }
}

