/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;

public class BufferingLog
implements PaxLogger {
    private ArrayList m_queue;
    private PaxContext m_context = new PaxContext();

    public BufferingLog() {
        this.m_queue = new ArrayList();
    }

    void flush(PaxLogger destination) {
        Iterator iterator = this.m_queue.iterator();
        while (iterator.hasNext()) {
            LogPackage pack = (LogPackage)iterator.next();
            Throwable throwable = pack.getException();
            String message = pack.getMessage();
            this.getPaxContext().putAll(pack.getContext());
            LogType logType = pack.getType();
            int logTypeAsInt = logType.getType();
            switch (logTypeAsInt) {
                case 1: {
                    destination.debug(message, throwable);
                    break;
                }
                case 0: {
                    destination.trace(message, throwable);
                    break;
                }
                case 2: {
                    destination.inform(message, throwable);
                    break;
                }
                case 3: {
                    destination.warn(message, throwable);
                    break;
                }
                case 4: {
                    destination.error(message, throwable);
                    break;
                }
                case 5: {
                    destination.fatal(message, throwable);
                }
            }
            this.getPaxContext().clear();
        }
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public void trace(String message, Throwable t) {
        LogPackage p = new LogPackage(LogType.trace, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    public void debug(String message, Throwable t) {
        LogPackage p = new LogPackage(LogType.debug, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    public void inform(String message, Throwable t) {
        LogPackage p = new LogPackage(LogType.info, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    public void warn(String message, Throwable t) {
        LogPackage p = new LogPackage(LogType.warn, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    public void error(String message, Throwable t) {
        LogPackage p = new LogPackage(LogType.error, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    public void fatal(String message, Throwable t) {
        LogPackage p = new LogPackage(LogType.fatal, message, t, this.getPaxContext().getContext());
        this.m_queue.add(p);
    }

    public int getLogLevel() {
        return 0;
    }

    public String getName() {
        return "";
    }

    public PaxContext getPaxContext() {
        return this.m_context;
    }

    private static class LogPackage {
        private LogType m_type;
        private String m_message;
        private Throwable m_exception;
        private Map m_context;

        public LogPackage(LogType type, String message, Throwable exception, Map context) {
            this.m_type = type;
            this.m_message = message;
            this.m_exception = exception;
            this.m_context = context;
        }

        public String getMessage() {
            return this.m_message;
        }

        public Throwable getException() {
            return this.m_exception;
        }

        public LogType getType() {
            return this.m_type;
        }

        public Map getContext() {
            return this.m_context;
        }
    }

    private static class LogType {
        private static final int TRACE_INT = 0;
        private static final int DEBUG_INT = 1;
        private static final int INFO_INT = 2;
        private static final int WARN_INT = 3;
        private static final int ERROR_INT = 4;
        private static final int FATAL_INT = 5;
        private static LogType trace = new LogType(0);
        private static LogType debug = new LogType(1);
        private static LogType info = new LogType(2);
        private static LogType warn = new LogType(3);
        private static LogType error = new LogType(4);
        private static LogType fatal = new LogType(5);
        private final int m_type;

        private LogType(int type) {
            this.m_type = type;
        }

        private int getType() {
            return this.m_type;
        }
    }
}

