/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.osgi;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.servicemix.kernel.gshell.core.OsgiCommandSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class InstallBundle
extends OsgiCommandSupport {
    @Argument(required=true, multiValued=true, description="Bundle URLs")
    List<String> urls;
    @Option(name="-s", aliases={"--start"}, description="Start the bundles after installation")
    boolean start;

    protected Object doExecute() throws Exception {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        StringBuffer sb = new StringBuffer();
        for (String url : this.urls) {
            Bundle bundle = this.install(url, this.io.out, this.io.err);
            if (bundle == null) continue;
            bundles.add(bundle);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(bundle.getBundleId());
        }
        if (this.start) {
            for (Bundle bundle : bundles) {
                bundle.start();
            }
        }
        if (sb.toString().indexOf(44) > 0) {
            this.io.out.println("Bundle IDs: " + sb.toString());
        } else if (sb.length() > 0) {
            this.io.out.println("Bundle ID: " + sb.toString());
        }
        return CommandAction.Result.SUCCESS;
    }

    protected Bundle install(String location, PrintWriter out, PrintWriter err) {
        try {
            return this.getBundleContext().installBundle(location, null);
        }
        catch (IllegalStateException ex) {
            err.println(ex.toString());
        }
        catch (BundleException ex) {
            if (ex.getNestedException() != null) {
                err.println(ex.getNestedException().toString());
            } else {
                err.println(ex.toString());
            }
        }
        catch (Exception ex) {
            err.println(ex.toString());
        }
        return null;
    }
}

