/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.osgi;

import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.Command;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.servicemix.kernel.gshell.core.OsgiCommandSupport;
import org.apache.servicemix.kernel.gshell.osgi.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class ListServices
extends OsgiCommandSupport {
    @Option(name="-a", description="Show all")
    boolean showAll;
    @Option(name="-u", description="Show in use")
    boolean inUse;
    @Argument(required=false, multiValued=true, description="Bundles ids")
    List<Long> ids;

    protected Object doExecute() throws Exception {
        if (this.ids != null && !this.ids.isEmpty()) {
            for (long id : this.ids) {
                Bundle bundle = this.getBundleContext().getBundle(id);
                if (bundle != null) {
                    boolean headerPrinted = false;
                    boolean needSeparator = false;
                    ServiceReference[] refs = null;
                    refs = this.inUse ? bundle.getServicesInUse() : bundle.getRegisteredServices();
                    for (int refIdx = 0; refs != null && refIdx < refs.length; ++refIdx) {
                        String[] objectClass = (String[])refs[refIdx].getProperty("objectClass");
                        boolean print = true;
                        for (int ocIdx = 0; !this.showAll && ocIdx < objectClass.length; ++ocIdx) {
                            if (!objectClass[ocIdx].equals(Command.class.getName())) continue;
                            print = false;
                        }
                        if (!headerPrinted) {
                            headerPrinted = true;
                            String title = Util.getBundleName(bundle);
                            title = this.inUse ? title + " uses:" : title + " provides:";
                            this.io.out.println("");
                            this.io.out.println(title);
                            this.io.out.println(Util.getUnderlineString(title));
                        }
                        if (!this.showAll && !print) continue;
                        if (needSeparator) {
                            this.io.out.println("----");
                        }
                        String[] keys = refs[refIdx].getPropertyKeys();
                        for (int keyIdx = 0; keys != null && keyIdx < keys.length; ++keyIdx) {
                            Object v = refs[refIdx].getProperty(keys[keyIdx]);
                            this.io.out.println(keys[keyIdx] + " = " + Util.getValueString(v));
                        }
                        needSeparator = true;
                    }
                    continue;
                }
                this.io.err.println("Bundle ID " + id + " is invalid.");
            }
        } else {
            Bundle[] bundles = this.getBundleContext().getBundles();
            if (bundles != null) {
                for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                    boolean headerPrinted = false;
                    ServiceReference[] refs = null;
                    refs = this.inUse ? bundles[bundleIdx].getServicesInUse() : bundles[bundleIdx].getRegisteredServices();
                    for (int refIdx = 0; refs != null && refIdx < refs.length; ++refIdx) {
                        String[] objectClass = (String[])refs[refIdx].getProperty("objectClass");
                        boolean print = true;
                        for (int ocIdx = 0; !this.showAll && ocIdx < objectClass.length; ++ocIdx) {
                            if (!objectClass[ocIdx].equals(Command.class.getName())) continue;
                            print = false;
                        }
                        if (!this.showAll && !print) continue;
                        if (!headerPrinted) {
                            headerPrinted = true;
                            String title = Util.getBundleName(bundles[bundleIdx]);
                            title = this.inUse ? title + " uses:" : title + " provides:";
                            this.io.out.println("\n" + title);
                            this.io.out.println(Util.getUnderlineString(title));
                        }
                        this.io.out.println(Util.getValueString(objectClass));
                    }
                }
            } else {
                this.io.out.println("There are no registered services.");
            }
        }
        return CommandAction.Result.SUCCESS;
    }
}

