/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.activator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.osgi.context.ConfigurableOsgiBundleApplicationContext;
import org.springframework.osgi.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEventMulticaster;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextListener;
import org.springframework.osgi.extender.OsgiApplicationContextCreator;
import org.springframework.osgi.extender.internal.activator.ListListenerAdapter;
import org.springframework.osgi.extender.internal.activator.SpringTypeCompatibilityChecker;
import org.springframework.osgi.extender.internal.dependencies.shutdown.BundleDependencyComparator;
import org.springframework.osgi.extender.internal.dependencies.shutdown.ComparatorServiceDependencySorter;
import org.springframework.osgi.extender.internal.dependencies.shutdown.ServiceDependencySorter;
import org.springframework.osgi.extender.internal.dependencies.startup.DependencyWaiterApplicationContextExecutor;
import org.springframework.osgi.extender.internal.support.ExtenderConfiguration;
import org.springframework.osgi.extender.internal.support.NamespaceManager;
import org.springframework.osgi.extender.internal.support.OsgiBeanFactoryPostProcessorAdapter;
import org.springframework.osgi.extender.internal.util.concurrent.Counter;
import org.springframework.osgi.extender.internal.util.concurrent.RunnableTimedExecution;
import org.springframework.osgi.extender.support.ApplicationContextConfiguration;
import org.springframework.osgi.extender.support.internal.ConfigUtils;
import org.springframework.osgi.service.importer.support.Cardinality;
import org.springframework.osgi.service.importer.support.CollectionType;
import org.springframework.osgi.service.importer.support.OsgiServiceCollectionProxyFactoryBean;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.Assert;

public class ContextLoaderListener
implements BundleActivator {
    private static final Log log = LogFactory.getLog((Class)ContextLoaderListener.class);
    private Timer timer = new Timer(true);
    private long bundleId;
    private ExtenderConfiguration extenderConfiguration;
    private final Map managedContexts;
    private TaskExecutor taskExecutor;
    private OsgiApplicationContextCreator contextCreator;
    private List postProcessors;
    private TaskExecutor sameThreadTaskExecutor = new SyncTaskExecutor();
    private Counter contextsStarted = new Counter("contextsStarted");
    private NamespaceManager nsManager;
    private BundleContext bundleContext;
    private SynchronousBundleListener contextListener;
    private SynchronousBundleListener nsListener;
    private ServiceDependencySorter shutdownDependencySorter = new ComparatorServiceDependencySorter();
    private final transient Object monitor = new Object();
    private boolean isClosed = false;
    private Version extenderVersion;
    private OsgiBundleApplicationContextEventMulticaster multicaster;
    private List applicationListeners;
    private DisposableBean applicationListenersCleaner;
    private SpringTypeCompatibilityChecker compatibilityChecker;
    private Bundle wiredSpringBundle;
    private TaskExecutor shutdownTaskExecutor;

    public ContextLoaderListener() {
        this.managedContexts = CollectionFactory.createConcurrentMap((int)16);
    }

    public void start(BundleContext context) throws Exception {
        int i;
        this.bundleContext = context;
        this.bundleId = context.getBundle().getBundleId();
        this.extenderVersion = OsgiBundleUtils.getBundleVersion((Bundle)context.getBundle());
        log.info((Object)("Starting [" + this.bundleContext.getBundle().getSymbolicName() + "] bundle v.[" + this.extenderVersion + "]"));
        this.detectSpringVersion(context);
        this.compatibilityChecker = new SpringTypeCompatibilityChecker(this.bundleContext);
        this.nsManager = new NamespaceManager(context);
        this.nsListener = new NamespaceBundleLister();
        context.addBundleListener((BundleListener)this.nsListener);
        Bundle[] previousBundles = context.getBundles();
        for (i = 0; i < previousBundles.length; ++i) {
            Bundle bundle = previousBundles[i];
            if (!OsgiBundleUtils.isBundleResolved((Bundle)bundle)) continue;
            this.maybeAddNamespaceHandlerFor(bundle);
        }
        this.nsManager.afterPropertiesSet();
        this.extenderConfiguration = new ExtenderConfiguration(context);
        this.taskExecutor = this.extenderConfiguration.getTaskExecutor();
        this.shutdownTaskExecutor = this.extenderConfiguration.getShutdownTaskExecutor();
        this.contextCreator = this.extenderConfiguration.getContextCreator();
        this.postProcessors = this.extenderConfiguration.getPostProcessors();
        this.initListenerService();
        this.contextListener = new ContextBundleListener();
        context.addBundleListener((BundleListener)this.contextListener);
        previousBundles = context.getBundles();
        for (i = 0; i < previousBundles.length; ++i) {
            if (!OsgiBundleUtils.isBundleActive((Bundle)previousBundles[i])) continue;
            try {
                this.maybeCreateApplicationContextFor(previousBundles[i]);
                continue;
            }
            catch (Throwable e) {
                log.warn((Object)("Cannot start bundle " + OsgiStringUtils.nullSafeSymbolicName((Bundle)previousBundles[i]) + " due to"), e);
            }
        }
    }

    private void detectSpringVersion(BundleContext context) {
        boolean debug = log.isDebugEnabled();
        ServiceReference ref = this.bundleContext.getServiceReference(PackageAdmin.class.getName());
        if (ref != null) {
            PackageAdmin pa = (PackageAdmin)this.bundleContext.getService(ref);
            this.wiredSpringBundle = pa.getBundle(Assert.class);
        } else {
            if (debug) {
                log.debug((Object)"PackageAdmin not available; falling back to raw class loading for detecting the wired Spring bundle");
            }
            this.wiredSpringBundle = SpringTypeCompatibilityChecker.findOriginatingBundle(context, Assert.class);
            if (this.wiredSpringBundle == null) {
                throw new IllegalStateException("Impossible to find the originating Spring bundle for " + Assert.class + "; bailing out");
            }
        }
        if (debug) {
            log.debug((Object)("Spring-DM v.[" + this.extenderVersion + "] is wired to Spring core bundle " + OsgiStringUtils.nullSafeSymbolicName((Bundle)this.wiredSpringBundle) + " version [" + OsgiBundleUtils.getBundleVersion((Bundle)this.wiredSpringBundle) + "]"));
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        log.info((Object)("Stopping [" + this.bundleContext.getBundle().getSymbolicName() + "] bundle v.[" + this.extenderVersion + "]"));
        this.stopTimer();
        if (this.contextListener != null) {
            this.bundleContext.removeBundleListener((BundleListener)this.contextListener);
            this.contextListener = null;
        }
        if (this.nsListener != null) {
            this.bundleContext.removeBundleListener((BundleListener)this.nsListener);
            this.nsListener = null;
        }
        Bundle[] bundles = new Bundle[this.managedContexts.size()];
        int i = 0;
        Iterator it = this.managedContexts.values().iterator();
        while (it.hasNext()) {
            ConfigurableOsgiBundleApplicationContext context = (ConfigurableOsgiBundleApplicationContext)it.next();
            bundles[i++] = context.getBundle();
        }
        bundles = this.shutdownDependencySorter.computeServiceDependencyGraph(bundles);
        boolean debug = log.isDebugEnabled();
        StringBuffer buffer = new StringBuffer();
        if (debug) {
            buffer.append("Shutdown order is: {");
            for (i = 0; i < bundles.length; ++i) {
                buffer.append("\nBundle [" + bundles[i].getSymbolicName() + "]");
                ServiceReference[] services = bundles[i].getServicesInUse();
                HashSet<Bundle> usedBundles = new HashSet<Bundle>();
                for (int j = 0; j < services.length; ++j) {
                    Bundle used;
                    if (!BundleDependencyComparator.isSpringManagedService(services[j]) || (used = services[j].getBundle()).equals(this.bundleContext.getBundle()) || usedBundles.contains(used)) continue;
                    usedBundles.add(used);
                    buffer.append("\n  Using [" + used.getSymbolicName() + "]");
                }
            }
            buffer.append("\n}");
            log.debug((Object)buffer);
        }
        ArrayList<1> taskList = new ArrayList<1>(this.managedContexts.size());
        final List<ConfigurableOsgiBundleApplicationContext> closedContexts = Collections.synchronizedList(new ArrayList());
        final Object[] contextClosingDown = new Object[1];
        for (i = 0; i < bundles.length; ++i) {
            Long id = new Long(bundles[i].getBundleId());
            final ConfigurableOsgiBundleApplicationContext context = (ConfigurableOsgiBundleApplicationContext)this.managedContexts.get(id);
            if (context == null) continue;
            closedContexts.add(context);
            taskList.add(new Runnable(){
                private final String toString;
                {
                    this.toString = "Closing runnable for context " + context.getDisplayName();
                }

                public void run() {
                    contextClosingDown[0] = context;
                    closedContexts.remove(context);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closing appCtx " + context.getDisplayName()));
                    }
                    context.close();
                }

                public String toString() {
                    return this.toString;
                }
            });
        }
        Runnable[] tasks = taskList.toArray(new Runnable[taskList.size()]);
        for (int j = 0; j < tasks.length; ++j) {
            if (!RunnableTimedExecution.execute(tasks[j], this.extenderConfiguration.getShutdownWaitTime(), this.shutdownTaskExecutor) || !debug) continue;
            log.debug((Object)(contextClosingDown[0] + " context did not close successfully; forcing shutdown..."));
        }
        this.managedContexts.clear();
        this.nsManager.destroy();
        if (this.applicationListeners != null) {
            this.applicationListeners = null;
            try {
                this.applicationListenersCleaner.destroy();
            }
            catch (Exception ex) {
                log.warn((Object)"exception thrown while releasing OSGi event listeners", (Throwable)ex);
            }
        }
        if (this.multicaster != null) {
            this.multicaster.removeAllListeners();
            this.multicaster = null;
        }
        this.stopTaskExecutor();
        this.extenderConfiguration.destroy();
    }

    private void stopTimer() {
        if (this.timer != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Canceling timer tasks");
            }
            this.timer.cancel();
        }
        this.timer = null;
    }

    private void stopTaskExecutor() {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Waiting for " + this.contextsStarted + " service dependency listener(s) to stop..."));
        }
        this.contextsStarted.waitForZero(this.extenderConfiguration.getShutdownWaitTime());
        if (!this.contextsStarted.isZero()) {
            if (debug) {
                log.debug((Object)(this.contextsStarted.getValue() + " service dependency listener(s) did not responded in time; forcing them to shutdown..."));
            }
            this.extenderConfiguration.setForceThreadShutdown(true);
        } else {
            log.debug((Object)"All listeners closed");
        }
    }

    private boolean handlerBundleMatchesExtenderVersion(Bundle bundle) {
        if (!ConfigUtils.matchExtenderVersionRange(bundle, this.extenderVersion)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "] expects an extender w/ version[" + OsgiBundleUtils.getHeaderAsVersion((Bundle)bundle, (String)"SpringExtender-Version") + "] which does not match current extender w/ version[" + this.extenderVersion + "]; skipping bundle from handler detection"));
            }
            return false;
        }
        return true;
    }

    private void maybeAddNamespaceHandlerFor(Bundle bundle) {
        if (this.handlerBundleMatchesExtenderVersion(bundle)) {
            this.nsManager.maybeAddNamespaceHandlerFor(bundle);
        }
    }

    private void maybeRemoveNameSpaceHandlerFor(Bundle bundle) {
        if (this.handlerBundleMatchesExtenderVersion(bundle)) {
            this.nsManager.maybeRemoveNameSpaceHandlerFor(bundle);
        }
    }

    protected void maybeCreateApplicationContextFor(Bundle bundle) {
        String creationType;
        DelegatedExecutionOsgiBundleApplicationContext localApplicationContext;
        boolean debug = log.isDebugEnabled();
        String bundleString = "[" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "]";
        Long bundleId = new Long(bundle.getBundleId());
        if (this.managedContexts.containsKey(bundleId)) {
            if (debug) {
                log.debug((Object)("Bundle " + bundleString + " is already managed; ignoring..."));
            }
            return;
        }
        if (!ConfigUtils.matchExtenderVersionRange(bundle, this.extenderVersion)) {
            if (debug) {
                log.debug((Object)("Bundle " + bundleString + " expects an extender w/ version[" + OsgiBundleUtils.getHeaderAsVersion((Bundle)bundle, (String)"SpringExtender-Version") + "] which does not match current extender w/ version[" + this.extenderVersion + "]; skipping bundle from context creation"));
            }
            return;
        }
        BundleContext localBundleContext = OsgiBundleUtils.getBundleContext((Bundle)bundle);
        if (debug) {
            log.debug((Object)("Scanning bundle " + bundleString + " for configurations..."));
        }
        if (debug) {
            log.debug((Object)("Creating an application context for bundle " + bundleString));
        }
        try {
            localApplicationContext = this.contextCreator.createApplicationContext(localBundleContext);
        }
        catch (Exception ex) {
            log.error((Object)("Cannot create application context for bundle " + bundleString), (Throwable)ex);
            return;
        }
        if (localApplicationContext == null) {
            log.debug((Object)("No application context created for bundle " + bundleString));
            return;
        }
        if (!this.compatibilityChecker.checkCompatibility(bundle)) {
            log.debug((Object)("Ignoring bundle " + bundleString + " as it's Spring incompatible with Spring-DM..."));
            return;
        }
        log.debug((Object)("Bundle " + bundleString + " is Spring type compatible with Spring-DM"));
        OsgiBeanFactoryPostProcessorAdapter processingHook = new OsgiBeanFactoryPostProcessorAdapter(localBundleContext, this.postProcessors);
        localApplicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)processingHook);
        this.managedContexts.put(bundleId, localApplicationContext);
        localApplicationContext.setDelegatedEventMulticaster(this.multicaster);
        Runnable contextRefresh = new Runnable(){

            public void run() {
                localApplicationContext.refresh();
            }
        };
        TaskExecutor executor = null;
        ApplicationContextConfiguration config = new ApplicationContextConfiguration(bundle);
        if (config.isCreateAsynchronously()) {
            executor = this.taskExecutor;
            creationType = "Asynchronous";
        } else {
            executor = this.sameThreadTaskExecutor;
            creationType = "Synchronous";
        }
        if (debug) {
            log.debug((Object)(creationType + " context creation for bundle " + bundleString));
        }
        if (config.isWaitForDependencies()) {
            DependencyWaiterApplicationContextExecutor appCtxExecutor = new DependencyWaiterApplicationContextExecutor(localApplicationContext, !config.isCreateAsynchronously(), this.extenderConfiguration.getDependencyFactories());
            appCtxExecutor.setTimeout(config.getTimeout());
            appCtxExecutor.setWatchdog(this.timer);
            appCtxExecutor.setTaskExecutor(executor);
            appCtxExecutor.setMonitoringCounter(this.contextsStarted);
            appCtxExecutor.setDelegatedMulticaster(this.multicaster);
            this.contextsStarted.increment();
        }
        executor.execute(contextRefresh);
    }

    protected void maybeCloseApplicationContextFor(Bundle bundle) {
        final ConfigurableOsgiBundleApplicationContext context = (ConfigurableOsgiBundleApplicationContext)this.managedContexts.remove(new Long(bundle.getBundleId()));
        if (context == null) {
            return;
        }
        RunnableTimedExecution.execute(new Runnable(){
            private final String toString;
            {
                this.toString = "Closing runnable for context " + context.getDisplayName();
            }

            public void run() {
                if (context.isActive()) {
                    context.close();
                }
            }

            public String toString() {
                return this.toString;
            }
        }, this.extenderConfiguration.getShutdownWaitTime(), this.shutdownTaskExecutor);
    }

    private void initListenerService() {
        this.multicaster = this.extenderConfiguration.getEventMulticaster();
        this.createListenersList();
        this.multicaster.addApplicationListener((OsgiBundleApplicationContextListener)new ListListenerAdapter(this.applicationListeners));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initialization of OSGi listeners service completed...");
        }
    }

    private void createListenersList() {
        OsgiServiceCollectionProxyFactoryBean fb = new OsgiServiceCollectionProxyFactoryBean();
        fb.setBundleContext(this.bundleContext);
        fb.setCardinality(Cardinality.C_0__N);
        fb.setCollectionType(CollectionType.LIST);
        fb.setInterfaces(new Class[]{OsgiBundleApplicationContextListener.class});
        fb.setBeanClassLoader(this.extenderConfiguration.getClassLoader());
        fb.afterPropertiesSet();
        this.applicationListenersCleaner = fb;
        this.applicationListeners = (List)fb.getObject();
    }

    private class ContextBundleListener
    extends BaseListener {
        private ContextBundleListener() {
        }

        protected void handleEvent(BundleEvent event) {
            Bundle bundle = event.getBundle();
            if (bundle.getBundleId() == ContextLoaderListener.this.bundleId) {
                return;
            }
            switch (event.getType()) {
                case 2: {
                    ContextLoaderListener.this.maybeCreateApplicationContextFor(bundle);
                    break;
                }
                case 256: {
                    if (OsgiBundleUtils.isSystemBundle((Bundle)bundle)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"System bundle stopping");
                        }
                        ContextLoaderListener.this.shutdown();
                        break;
                    }
                    ContextLoaderListener.this.maybeCloseApplicationContextFor(bundle);
                    break;
                }
            }
        }
    }

    private class NamespaceBundleLister
    extends BaseListener {
        private NamespaceBundleLister() {
        }

        protected void handleEvent(BundleEvent event) {
            Bundle bundle = event.getBundle();
            switch (event.getType()) {
                case 32: {
                    ContextLoaderListener.this.maybeAddNamespaceHandlerFor(bundle);
                    break;
                }
                case 64: {
                    ContextLoaderListener.this.maybeRemoveNameSpaceHandlerFor(bundle);
                    break;
                }
            }
        }
    }

    private abstract class BaseListener
    implements SynchronousBundleListener {
        private BaseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            boolean trace = log.isTraceEnabled();
            Object object = ContextLoaderListener.this.monitor;
            synchronized (object) {
                if (ContextLoaderListener.this.isClosed) {
                    if (trace) {
                        log.trace((Object)"Listener is closed; events are being ignored");
                    }
                    return;
                }
            }
            if (trace) {
                log.debug((Object)("Processing bundle event [" + OsgiStringUtils.nullSafeToString((BundleEvent)event) + "] for bundle [" + OsgiStringUtils.nullSafeSymbolicName((Bundle)event.getBundle()) + "]"));
            }
            try {
                this.handleEvent(event);
            }
            catch (Exception ex) {
                log.warn((Object)("Got exception while handling event " + event), (Throwable)ex);
            }
        }

        protected abstract void handleEvent(BundleEvent var1);
    }
}

