/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.activator;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.io.internal.resolver.DependencyResolver;
import org.springframework.osgi.io.internal.resolver.ImportedBundle;
import org.springframework.osgi.io.internal.resolver.PackageAdminResolver;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.util.Assert;

class SpringTypeCompatibilityChecker {
    private static Class SPRING_TYPE = Assert.class;
    private final DependencyResolver dependencyResolver;

    SpringTypeCompatibilityChecker(BundleContext bundleContext) {
        this.dependencyResolver = new PackageAdminResolver(bundleContext);
    }

    boolean checkCompatibility(Bundle bundle) {
        Assert.notNull((Object)bundle);
        Boolean typeComparison = SpringTypeCompatibilityChecker.isTypeAvailable(bundle, SPRING_TYPE);
        if (typeComparison != null) {
            return typeComparison;
        }
        ImportedBundle[] importedBundles = this.dependencyResolver.getImportedBundles(bundle);
        return this.checkImportedBundles(importedBundles);
    }

    private boolean checkImportedBundles(ImportedBundle[] importedBundles) {
        for (int i = 0; i < importedBundles.length; ++i) {
            Boolean comparsion;
            Bundle bundle = importedBundles[i].getBundle();
            if (OsgiBundleUtils.isSystemBundle((Bundle)bundle) || (comparsion = SpringTypeCompatibilityChecker.isTypeAvailable(bundle, SPRING_TYPE)) == null) continue;
            return comparsion;
        }
        return true;
    }

    private static Boolean isTypeAvailable(Bundle bundle, Class type) {
        try {
            Class newType = bundle.loadClass(type.getName());
            return type.equals(newType);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    static Bundle findOriginatingBundle(BundleContext context, Class type) {
        Bundle[] bundles = context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            Boolean isAvailable = SpringTypeCompatibilityChecker.isTypeAvailable(bundle, type);
            if (isAvailable == null || !isAvailable.booleanValue()) continue;
            return bundle;
        }
        return null;
    }
}

