/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.osgi.jmx;

import com.oracle.osgi.jmx.compendium.ConfigAdminManager;
import com.oracle.osgi.jmx.compendium.PermissionManager;
import com.oracle.osgi.jmx.compendium.Provisioning;
import com.oracle.osgi.jmx.compendium.UserManager;
import com.oracle.osgi.jmx.core.BundleState;
import com.oracle.osgi.jmx.core.Framework;
import com.oracle.osgi.jmx.core.PackageState;
import com.oracle.osgi.jmx.core.ServiceState;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.compendium.ConfigAdminManagerMBean;
import org.osgi.jmx.compendium.PermissionManagerMBean;
import org.osgi.jmx.compendium.ProvisioningMBean;
import org.osgi.jmx.compendium.UserManagerMBean;
import org.osgi.jmx.core.BundleStateMBean;
import org.osgi.jmx.core.FrameworkMBean;
import org.osgi.jmx.core.PackageStateMBean;
import org.osgi.jmx.core.ServiceStateMBean;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.provisioning.ProvisioningService;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.service.useradmin.UserAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static final Log log = LogFactory.getLog(Activator.class);
    protected MBeanServer mbeanServer;
    protected StandardMBean bundleState;
    protected StandardMBean packageState;
    protected StandardMBean serviceState;
    protected BundleContext bundleContext;
    protected ObjectName bundlesStateName;
    protected StandardMBean framework;
    protected ObjectName frameworkName;
    protected ServiceTracker mbeanServiceTracker;
    protected ObjectName packageStateName;
    protected ObjectName serviceStateName;
    protected AtomicBoolean servicesRegistered = new AtomicBoolean(false);
    protected ServiceTracker configAdminTracker;
    protected ServiceTracker permissionAdminTracker;
    protected ServiceTracker provisioningServiceTracker;
    protected ServiceTracker userAdminTracker;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.frameworkName = new ObjectName("osgi.core:type=framework");
        this.bundlesStateName = new ObjectName("osgi.core:type=bundleState");
        this.serviceStateName = new ObjectName("osgi.core:type=serviceState");
        this.packageStateName = new ObjectName("osgi.core:type=packageState");
        this.mbeanServiceTracker = new ServiceTracker(bundleContext, MBeanServer.class.getCanonicalName(), (ServiceTrackerCustomizer)new MBeanServiceTracker());
        log.debug((Object)"Awaiting MBeanServer service registration");
        this.mbeanServiceTracker.open();
    }

    public void stop(BundleContext arg0) throws Exception {
        this.mbeanServiceTracker.close();
        this.deregisterServices();
        this.mbeanServer = null;
    }

    protected synchronized void deregisterServices() {
        if (!this.servicesRegistered.get()) {
            return;
        }
        log.debug((Object)("Deregistering framework with MBeanServer: " + this.mbeanServer));
        try {
            this.mbeanServer.unregisterMBean(this.frameworkName);
        }
        catch (InstanceNotFoundException e) {
            log.trace((Object)"FrameworkMBean not found on deregistration", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.debug((Object)"FrameworkMBean deregistration problem", (Throwable)e);
        }
        this.framework = null;
        try {
            this.mbeanServer.unregisterMBean(this.bundlesStateName);
        }
        catch (InstanceNotFoundException e) {
            log.trace((Object)"OSGi BundleStateMBean not found on deregistration", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.debug((Object)"OSGi BundleStateMBean deregistration problem", (Throwable)e);
        }
        this.bundleState = null;
        log.debug((Object)("Deregistering services monitor with MBeanServer: " + this.mbeanServer));
        try {
            this.mbeanServer.unregisterMBean(this.serviceStateName);
        }
        catch (InstanceNotFoundException e) {
            log.trace((Object)"OSGi ServiceStateMBean not found on deregistration", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.debug((Object)"OSGi ServiceStateMBean deregistration problem", (Throwable)e);
        }
        this.serviceState = null;
        log.debug((Object)("Deregistering packages monitor with MBeanServer: " + this.mbeanServer));
        try {
            this.mbeanServer.unregisterMBean(this.packageStateName);
        }
        catch (InstanceNotFoundException e) {
            log.trace((Object)"OSGi PackageStateMBean not found on deregistration", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.debug((Object)"OSGi PackageStateMBean deregistration problem", (Throwable)e);
        }
        this.packageState = null;
        this.configAdminTracker.close();
        this.configAdminTracker = null;
        this.permissionAdminTracker.close();
        this.permissionAdminTracker = null;
        this.provisioningServiceTracker.close();
        this.provisioningServiceTracker = null;
        this.userAdminTracker.close();
        this.userAdminTracker = null;
        this.servicesRegistered.set(false);
    }

    protected synchronized void registerServices() {
        PackageAdmin admin = (PackageAdmin)this.bundleContext.getService(this.bundleContext.getServiceReference(PackageAdmin.class.getCanonicalName()));
        StartLevel sl = (StartLevel)this.bundleContext.getService(this.bundleContext.getServiceReference(StartLevel.class.getCanonicalName()));
        try {
            this.framework = new StandardMBean(new Framework(this.bundleContext, admin, sl), FrameworkMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            log.fatal((Object)"Unable to create StandardMBean for Framework", (Throwable)e);
            return;
        }
        try {
            this.bundleState = new StandardMBean(new BundleState(this.bundleContext, sl, admin), BundleStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            log.fatal((Object)"Unable to create StandardMBean for BundleState", (Throwable)e);
            return;
        }
        try {
            this.serviceState = new StandardMBean(new ServiceState(this.bundleContext), ServiceStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            log.fatal((Object)"Unable to create StandardMBean for ServiceState", (Throwable)e);
            return;
        }
        try {
            this.packageState = new StandardMBean(new PackageState(this.bundleContext, admin), PackageStateMBean.class);
        }
        catch (NotCompliantMBeanException e) {
            log.fatal((Object)"Unable to create StandardMBean for PackageState", (Throwable)e);
            return;
        }
        log.debug((Object)("Registering Framework with MBeanServer: " + this.mbeanServer + " with name: " + this.frameworkName));
        try {
            this.mbeanServer.registerMBean(this.framework, this.frameworkName);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error((Object)"Cannot register OSGi framework MBean", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error((Object)"Cannot register OSGi framework MBean", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error((Object)"Cannot register OSGi framework MBean", (Throwable)e);
        }
        log.debug((Object)("Registering bundle state monitor with MBeanServer: " + this.mbeanServer + " with name: " + this.bundlesStateName));
        try {
            this.mbeanServer.registerMBean(this.bundleState, this.bundlesStateName);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error((Object)"Cannot register OSGi BundleStateMBean", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error((Object)"Cannot register OSGi BundleStateMBean", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error((Object)"Cannot register OSGi BundleStateMBean", (Throwable)e);
        }
        log.debug((Object)("Registering services monitor with MBeanServer: " + this.mbeanServer + " with name: " + this.serviceStateName));
        try {
            this.mbeanServer.registerMBean(this.serviceState, this.serviceStateName);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error((Object)"Cannot register OSGi ServiceStateMBean", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error((Object)"Cannot register OSGi ServiceStateMBean", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error((Object)"Cannot register OSGi ServiceStateMBean", (Throwable)e);
        }
        log.debug((Object)("Registering packages monitor with MBeanServer: " + this.mbeanServer + " with name: " + this.packageStateName));
        try {
            this.mbeanServer.registerMBean(this.packageState, this.packageStateName);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error((Object)"Cannot register OSGi PackageStateMBean", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error((Object)"Cannot register OSGi PackageStateMBean", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error((Object)"Cannot register OSGi PackageStateMBean", (Throwable)e);
        }
        this.configAdminTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.cm.ConfigurationAdmin", (ServiceTrackerCustomizer)new ConfigAdminTracker());
        this.permissionAdminTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.permissionadmin.PermissionAdmin", (ServiceTrackerCustomizer)new PermissionAdminTracker());
        this.provisioningServiceTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.provisioning.ProvisioningService", (ServiceTrackerCustomizer)new ProvisioningServiceTracker());
        this.userAdminTracker = new ServiceTracker(this.bundleContext, "org.osgi.service.useradmin.UserAdmin", (ServiceTrackerCustomizer)new UserAdminTracker());
        this.configAdminTracker.open();
        this.permissionAdminTracker.open();
        this.provisioningServiceTracker.open();
        this.userAdminTracker.open();
        this.servicesRegistered.set(true);
    }

    class UserAdminTracker
    implements ServiceTrackerCustomizer {
        StandardMBean manager;
        ObjectName name;

        public UserAdminTracker() {
            try {
                this.name = new ObjectName("osgi.compendium:service=useradmin");
            }
            catch (Throwable e) {
                throw new IllegalStateException("unable to create object name: osgi.compendium:service=useradmin");
            }
        }

        public Object addingService(ServiceReference reference) {
            log.debug((Object)("Registering user admin with MBeanServer: " + Activator.this.mbeanServer + " with name: " + this.name));
            UserAdmin admin = (UserAdmin)Activator.this.bundleContext.getService(reference);
            try {
                this.manager = new StandardMBean(new UserManager(admin), UserManagerMBean.class);
            }
            catch (NotCompliantMBeanException e1) {
                log.fatal((Object)"Unable to create User Admin Manager");
                return admin;
            }
            try {
                Activator.this.mbeanServer.registerMBean(this.manager, this.name);
            }
            catch (InstanceAlreadyExistsException e) {
                log.error((Object)"Cannot register User Manager MBean", (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                log.error((Object)"Cannot register User Manager MBean", (Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                log.error((Object)"Cannot register User Manager MBean", (Throwable)e);
            }
            return admin;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            log.debug((Object)("Deregistering user admin with MBeanServer: " + Activator.this.mbeanServer + " with name: " + this.name));
            try {
                Activator.this.mbeanServer.unregisterMBean(this.name);
            }
            catch (InstanceNotFoundException e) {
                log.debug((Object)"User Manager MBean was never registered");
            }
            catch (MBeanRegistrationException e) {
                log.error((Object)"Cannot deregister User Manager MBean", (Throwable)e);
            }
        }
    }

    class ProvisioningServiceTracker
    implements ServiceTrackerCustomizer {
        StandardMBean provisioning;
        ObjectName name;

        public ProvisioningServiceTracker() {
            try {
                this.name = new ObjectName("osgi.compendium:service=manager");
            }
            catch (Throwable e) {
                throw new IllegalStateException("unable to create object name: osgi.compendium:service=manager");
            }
        }

        public Object addingService(ServiceReference reference) {
            log.debug((Object)("Registering provisioning service with MBeanServer: " + Activator.this.mbeanServer + " with name: " + this.name));
            ProvisioningService admin = (ProvisioningService)Activator.this.bundleContext.getService(reference);
            try {
                this.provisioning = new StandardMBean(new Provisioning(admin), ProvisioningMBean.class);
            }
            catch (NotCompliantMBeanException e1) {
                log.fatal((Object)"Unable to create Provisioning Service Manager");
                return admin;
            }
            try {
                Activator.this.mbeanServer.registerMBean(this.provisioning, this.name);
            }
            catch (InstanceAlreadyExistsException e) {
                log.error((Object)"Cannot register Provisioning Service MBean", (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                log.error((Object)"Cannot register Provisioning Service MBean", (Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                log.error((Object)"Cannot register Provisioning Service MBean", (Throwable)e);
            }
            return admin;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            log.debug((Object)("deregistering provisioning service with MBeanServer: " + Activator.this.mbeanServer + " with name: " + this.name));
            try {
                Activator.this.mbeanServer.unregisterMBean(this.name);
            }
            catch (InstanceNotFoundException e) {
                log.debug((Object)"Provisioning Service MBean was never registered");
            }
            catch (MBeanRegistrationException e) {
                log.error((Object)"Cannot deregister Provisioning Service MBean", (Throwable)e);
            }
        }
    }

    class PermissionAdminTracker
    implements ServiceTrackerCustomizer {
        StandardMBean manager;
        ObjectName name;

        public PermissionAdminTracker() {
            try {
                this.name = new ObjectName("osgi.compendium:service=permissionadmin");
            }
            catch (Throwable e) {
                throw new IllegalStateException("unable to create object name: osgi.compendium:service=permissionadmin");
            }
        }

        public Object addingService(ServiceReference reference) {
            log.debug((Object)("Registering permission admin with MBeanServer: " + Activator.this.mbeanServer + " with name: " + this.name));
            PermissionAdmin admin = (PermissionAdmin)Activator.this.bundleContext.getService(reference);
            try {
                this.manager = new StandardMBean(new PermissionManager(admin), PermissionManagerMBean.class);
            }
            catch (NotCompliantMBeanException e1) {
                log.fatal((Object)"Unable to create Permission Admin Manager");
                return admin;
            }
            try {
                Activator.this.mbeanServer.registerMBean(this.manager, this.name);
            }
            catch (InstanceAlreadyExistsException e) {
                log.error((Object)"Cannot register Permission Manager MBean", (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                log.error((Object)"Cannot register Permission Manager MBean", (Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                log.error((Object)"Cannot register Permission Manager MBean", (Throwable)e);
            }
            return admin;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            log.debug((Object)("deregistering permission admin with MBeanServer: " + Activator.this.mbeanServer + " with name: " + this.name));
            try {
                Activator.this.mbeanServer.unregisterMBean(this.name);
            }
            catch (InstanceNotFoundException e) {
                log.debug((Object)"Permission Manager MBean was never registered");
            }
            catch (MBeanRegistrationException e) {
                log.error((Object)"Cannot deregister Permission Manager MBean", (Throwable)e);
            }
        }
    }

    class ConfigAdminTracker
    implements ServiceTrackerCustomizer {
        StandardMBean manager;
        ObjectName name;

        public ConfigAdminTracker() {
            try {
                this.name = new ObjectName("osgi.compendium:service=cm");
            }
            catch (Throwable e) {
                throw new IllegalStateException("unable to create object name: osgi.compendium:service=cm");
            }
        }

        public Object addingService(ServiceReference reference) {
            log.debug((Object)("Registering configuration admin with MBeanServer: " + Activator.this.mbeanServer + " with name: " + this.name));
            ConfigurationAdmin admin = (ConfigurationAdmin)Activator.this.bundleContext.getService(reference);
            try {
                this.manager = new StandardMBean(new ConfigAdminManager(admin), ConfigAdminManagerMBean.class);
            }
            catch (NotCompliantMBeanException e1) {
                log.fatal((Object)"Unable to create Configuration Admin Manager");
                return admin;
            }
            try {
                Activator.this.mbeanServer.registerMBean(this.manager, this.name);
            }
            catch (InstanceAlreadyExistsException e) {
                log.error((Object)"Cannot register Configuration Manager MBean", (Throwable)e);
            }
            catch (MBeanRegistrationException e) {
                log.error((Object)"Cannot register Configuration Manager MBean", (Throwable)e);
            }
            catch (NotCompliantMBeanException e) {
                log.error((Object)"Cannot register Configuration Manager MBean", (Throwable)e);
            }
            return admin;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            log.debug((Object)("deregistering configuration admin from: " + Activator.this.mbeanServer + " with name: " + this.name));
            try {
                Activator.this.mbeanServer.unregisterMBean(this.name);
            }
            catch (InstanceNotFoundException e) {
                log.debug((Object)"Configuration Manager MBean was never registered");
            }
            catch (MBeanRegistrationException e) {
                log.error((Object)"Cannot deregister Configuration Manager MBean", (Throwable)e);
            }
        }
    }

    class MBeanServiceTracker
    implements ServiceTrackerCustomizer {
        MBeanServiceTracker() {
        }

        public Object addingService(ServiceReference servicereference) {
            try {
                log.debug((Object)("Adding MBeanServer: " + servicereference));
                Activator.this.mbeanServer = (MBeanServer)Activator.this.bundleContext.getService(servicereference);
                Runnable registration = new Runnable(){

                    public void run() {
                        Activator.this.registerServices();
                    }
                };
                Thread registrationThread = new Thread(registration, "JMX Core MBean Registration");
                registrationThread.setDaemon(true);
                registrationThread.start();
                return Activator.this.mbeanServer;
            }
            catch (RuntimeException e) {
                log.error((Object)"uncaught exception in addingService", (Throwable)e);
                throw e;
            }
        }

        public void modifiedService(ServiceReference servicereference, Object obj) {
        }

        public void removedService(ServiceReference servicereference, Object obj) {
            try {
                log.debug((Object)("Removing MBeanServer: " + servicereference));
                Runnable deregister = new Runnable(){

                    public void run() {
                        Activator.this.deregisterServices();
                        Activator.this.mbeanServer = null;
                    }
                };
                Thread deregisterThread = new Thread(deregister, "JMX Core MBean Deregistration");
                deregisterThread.setDaemon(true);
                deregisterThread.start();
            }
            catch (Throwable e) {
                log.debug((Object)"uncaught exception in removedService", e);
            }
        }
    }
}

