/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.osgi.jmx.compendium;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.management.openmbean.TabularData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.jmx.codec.OSGiProperties;
import org.osgi.jmx.compendium.ConfigAdminManagerMBean;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigAdminManager
implements ConfigAdminManagerMBean {
    protected ConfigurationAdmin admin;
    private static final Log log = LogFactory.getLog(ConfigAdminManager.class);

    public ConfigAdminManager(ConfigurationAdmin admin) {
        this.admin = admin;
    }

    public void addProperty(String pid, String name, String value, String type) throws IOException {
        Configuration config = this.admin.getConfiguration(pid, null);
        Hashtable<String, Object> properties = config.getProperties();
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        ((Dictionary)properties).put(name, OSGiProperties.parse((String)value, (String)type));
        config.update(properties);
    }

    public void addProperty(String pid, String location, String name, String value, String type) throws IOException {
        Configuration config = this.admin.getConfiguration(pid, location);
        Hashtable<String, Object> properties = config.getProperties();
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        ((Dictionary)properties).put(name, OSGiProperties.parse((String)value, (String)type));
        config.update(properties);
    }

    public void addPropertyToConfigurations(String filter, String name, String value, String type) throws IOException {
        Configuration[] confs;
        Object v = OSGiProperties.parse((String)value, (String)type);
        try {
            confs = this.admin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException e) {
            log.error((Object)("Invalid filter argument: " + filter), (Throwable)e);
            throw new IllegalArgumentException("Invalid filter: " + (Object)((Object)e));
        }
        if (confs != null) {
            for (Configuration conf : confs) {
                Hashtable<String, Object> dic = conf.getProperties();
                if (dic == null) {
                    dic = new Hashtable<String, Object>();
                }
                ((Dictionary)dic).put(name, v);
                conf.update(dic);
            }
        }
    }

    public String createFactoryConfiguration(String factoryPid) throws IOException {
        return this.admin.createFactoryConfiguration(factoryPid, null).getPid();
    }

    public String createFactoryConfiguration(String factoryPid, String location) throws IOException {
        return this.admin.createFactoryConfiguration(factoryPid, location).getPid();
    }

    public void delete(String pid) throws IOException {
        this.admin.getConfiguration(pid, null).delete();
    }

    public void delete(String pid, String location) throws IOException {
        this.admin.getConfiguration(pid, location).delete();
    }

    public void deleteConfigurations(String filter) throws IOException {
        Configuration[] confs;
        try {
            confs = this.admin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException e) {
            log.error((Object)("Invalid filter argument: " + filter), (Throwable)e);
            throw new IllegalArgumentException("Invalid filter: " + (Object)((Object)e));
        }
        if (confs != null) {
            for (Configuration conf : confs) {
                conf.delete();
            }
        }
    }

    public void deleteProperty(String pid, String key) throws IOException {
        Configuration conf = this.admin.getConfiguration(pid, null);
        Dictionary props = conf.getProperties();
        if (props != null) {
            props.remove(key);
            conf.update(props);
        }
    }

    public void deleteProperty(String pid, String location, String key) throws IOException {
        Configuration conf = this.admin.getConfiguration(pid, location);
        Dictionary props = conf.getProperties();
        if (props != null) {
            props.remove(key);
            conf.update(props);
        }
    }

    public void deletePropertyFromConfigurations(String filter, String key) throws IOException {
        Configuration[] confs;
        try {
            confs = this.admin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException e) {
            log.error((Object)("Invalid filter argument: " + filter), (Throwable)e);
            throw new IllegalArgumentException("Invalid filter: " + (Object)((Object)e));
        }
        if (confs != null) {
            for (Configuration conf : confs) {
                Dictionary dic = conf.getProperties();
                if (dic == null) continue;
                dic.remove(key);
                conf.update(dic);
            }
        }
    }

    public String getBundleLocation(String pid) throws IOException {
        return this.admin.getConfiguration(pid, null).getBundleLocation();
    }

    public String getFactoryPid(String pid) throws IOException {
        return this.admin.getConfiguration(pid, null).getFactoryPid();
    }

    public String getFactoryPid(String pid, String location) throws IOException {
        return this.admin.getConfiguration(pid, location).getFactoryPid();
    }

    public TabularData getProperties(String pid) throws IOException {
        Dictionary properties = this.admin.getConfiguration(pid, null).getProperties();
        return properties == null ? null : OSGiProperties.tableFrom((Dictionary)properties);
    }

    public TabularData getProperties(String pid, String location) throws IOException {
        Dictionary properties = this.admin.getConfiguration(pid, location).getProperties();
        return properties == null ? null : OSGiProperties.tableFrom((Dictionary)properties);
    }

    public String[][] listConfigurations(String filter) throws IOException {
        Configuration[] configurations;
        ArrayList<String[]> pids = new ArrayList<String[]>();
        try {
            configurations = this.admin.listConfigurations(filter);
        }
        catch (InvalidSyntaxException e) {
            log.error((Object)("Invalid filter argument: " + filter), (Throwable)e);
            throw new IllegalArgumentException("Invalid filter: " + (Object)((Object)e));
        }
        if (configurations != null) {
            for (Configuration config : configurations) {
                pids.add(new String[]{config.getPid(), config.getBundleLocation()});
            }
        }
        return (String[][])pids.toArray((T[])new String[pids.size()][]);
    }

    public void setBundleLocation(String pid, String location) throws IOException {
        this.admin.getConfiguration(pid).setBundleLocation(location);
    }

    public void update(String pid, TabularData table) throws IOException {
        this.admin.getConfiguration(pid, null).update((Dictionary)OSGiProperties.propertiesFrom((TabularData)table));
    }

    public void update(String pid, String location, TabularData table) throws IOException {
        this.admin.getConfiguration(pid, location).update((Dictionary)OSGiProperties.propertiesFrom((TabularData)table));
    }
}

