/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit.commands;

import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.audit.AuditorMBean;
import org.apache.servicemix.nmr.audit.commands.AuditCommandSupport;

public class ExchangesCommand
extends AuditCommandSupport {
    @Option(name="--index", argumentRequired=true)
    int index = -1;
    @Option(name="--from", argumentRequired=true)
    int from = -1;
    @Option(name="--to", argumentRequired=true)
    int to = -1;
    @Option(name="--id", argumentRequired=true)
    String id;
    @Option(name="--all")
    boolean all;

    protected Object doExecute(AuditorMBean auditor) throws Exception {
        Exchange[] exchanges;
        if (this.index >= 0) {
            exchanges = new Exchange[]{auditor.getExchangeByIndex(this.index)};
        } else if (this.from >= 0 && this.to >= 0) {
            exchanges = auditor.getExchangesByRange(this.from, this.to);
        } else if (this.id != null) {
            exchanges = new Exchange[]{auditor.getExchangeById(this.id)};
        } else if (this.all) {
            exchanges = auditor.getAllExchanges();
        } else {
            this.io.err.println("One of [--index, --id, --all] option must be specified");
            return CommandAction.Result.FAILURE;
        }
        if (exchanges != null) {
            for (Exchange e : exchanges) {
                if (e == null) continue;
                this.io.out.println(e.display(true));
            }
        }
        return CommandAction.Result.SUCCESS;
    }
}

