/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.nmr.audit.commands;

import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.CommandAction;
import org.apache.servicemix.nmr.audit.AuditorMBean;
import org.apache.servicemix.nmr.audit.commands.AuditCommandSupport;

public class IdsCommand
extends AuditCommandSupport {
    @Option(name="--index")
    private int index = -1;
    @Option(name="--from")
    private int from = -1;
    @Option(name="--to")
    private int to = -1;
    @Option(name="--all")
    private boolean all;

    protected Object doExecute(AuditorMBean auditor) throws Exception {
        String[] ids;
        if (this.index >= 0) {
            ids = new String[]{auditor.getExchangeIdByIndex(this.index)};
        } else if (this.from >= 0 && this.to >= 0) {
            ids = auditor.getExchangeIdsByRange(this.from, this.to);
        } else if (this.all) {
            ids = auditor.getAllExchangeIds();
        } else {
            this.io.err.println("One of [--index, --id, --all] option must be specified");
            return CommandAction.Result.FAILURE;
        }
        if (ids == null || ids.length == 0) {
            this.io.out.println("No matching exchanges");
        } else {
            for (String id : ids) {
                if (id == null) continue;
                this.io.out.println(id);
            }
        }
        return CommandAction.Result.SUCCESS;
    }
}

