/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.config;

import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.servicemix.kernel.gshell.config.ConfigCommandSupport;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ListCommand
extends ConfigCommandSupport {
    @Argument(required=false, description="LDAP query")
    String query;

    protected void doExecute(ConfigurationAdmin admin) throws Exception {
        Configuration[] configs;
        for (Configuration config : configs = admin.listConfigurations(this.query)) {
            this.io.out.println("----------------------------------------------------------------");
            this.io.out.println("Pid:            " + config.getPid());
            if (config.getFactoryPid() != null) {
                this.io.out.println("FactoryPid:     " + config.getFactoryPid());
            }
            this.io.out.println("BundleLocation: " + config.getBundleLocation());
            if (config.getProperties() == null) continue;
            this.io.out.println("Properties:");
            Dictionary props = config.getProperties();
            Enumeration e = props.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                this.io.out.println("   " + key + " = " + props.get(key));
            }
        }
    }
}

