/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.internal;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PaxLoggingConfigurator;
import org.knopflerfish.service.log.LogService;
import org.ops4j.pax.logging.EventAdminTracker;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.internal.AppenderTracker;
import org.ops4j.pax.logging.internal.LogEntryImpl;
import org.ops4j.pax.logging.internal.LogReaderServiceImpl;
import org.ops4j.pax.logging.internal.PaxLoggerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.event.Event;
import org.osgi.service.log.LogEntry;

public class PaxLoggingServiceImpl
implements PaxLoggingService,
LogService,
ManagedService,
ServiceFactory {
    private LogReaderServiceImpl m_logReader;
    private EventAdminTracker m_eventAdmin;
    private AppenderTracker m_appenderTracker;
    private PaxContext m_context;
    private int m_logLevel = 4;

    public PaxLoggingServiceImpl(LogReaderServiceImpl logReader, EventAdminTracker eventAdmin, AppenderTracker appenderTracker) {
        this.m_appenderTracker = appenderTracker;
        this.m_logReader = logReader;
        this.m_eventAdmin = eventAdmin;
        this.m_context = new PaxContext();
        this.configureDefaults();
    }

    public PaxLogger getLogger(Bundle bundle, String category, String fqcn) {
        Logger log4jLogger = Logger.getLogger(category);
        return new PaxLoggerImpl(bundle, log4jLogger, fqcn, this);
    }

    public int getLogLevel() {
        return this.m_logLevel;
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, String message, Throwable exception) {
        this.log((ServiceReference)null, level, message, exception);
    }

    public void log(ServiceReference sr, int level, String message) {
        this.log(sr, level, message, null);
    }

    public void log(ServiceReference sr, int level, String message, Throwable exception) {
        this.log(null, sr, level, message, exception);
    }

    void log(Bundle bundle, int level, String message, Throwable exception) {
        this.log(bundle, null, level, message, exception);
    }

    private void log(Bundle bundle, ServiceReference sr, int level, String message, Throwable exception) {
        if (null == bundle && null != sr) {
            bundle = sr.getBundle();
        }
        String category = "[undefined]";
        if (bundle != null && null == (category = bundle.getSymbolicName())) {
            category = "[bundle@" + bundle.getBundleId() + ']';
        }
        PaxLogger logger = this.getLogger(bundle, category, "");
        switch (level) {
            case 1: {
                logger.error(message, exception);
                break;
            }
            case 2: {
                logger.warn(message, exception);
                break;
            }
            case 3: {
                logger.inform(message, exception);
                break;
            }
            case 4: {
                logger.debug(message, exception);
                break;
            }
            default: {
                logger.warn("Undefined Level: " + level + " : " + message, exception);
            }
        }
        this.handleEvents(bundle, sr, level, message, exception);
    }

    void handleEvents(Bundle bundle, ServiceReference sr, int level, String message, Throwable exception) {
        LogEntryImpl entry = new LogEntryImpl(bundle, sr, level, message, exception);
        this.m_logReader.fireEvent(entry);
        if (this.m_eventAdmin != null) {
            Event event = PaxLoggingServiceImpl.createEvent(bundle, level, entry, message, exception, sr, this.getPaxContext().getContext());
            this.m_eventAdmin.postEvent(event);
        }
    }

    public void updated(Dictionary configuration) throws ConfigurationException {
        if (configuration == null) {
            this.configureDefaults();
            return;
        }
        Properties extracted = new Properties();
        Enumeration list = configuration.keys();
        while (list.hasMoreElements()) {
            Object obj = list.nextElement();
            if (!(obj instanceof String)) continue;
            String key = (String)obj;
            Object value = configuration.get(obj);
            if (key.startsWith("log4j")) {
                extracted.put(key, value);
                continue;
            }
            if (!key.startsWith("pax.") || !"pax.logging.entries.size".equals(key)) continue;
            try {
                this.m_logReader.setMaxEntries(Integer.parseInt((String)value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (extracted.size() == 0) {
            this.configureDefaults();
            return;
        }
        PaxLoggingConfigurator configurator = new PaxLoggingConfigurator(this.m_appenderTracker);
        configurator.doConfigure(extracted, LogManager.getLoggerRepository());
    }

    private void configureDefaults() {
        String levelName = System.getProperty("org.ops4j.pax.logging.DefaultServiceLog.level", "DEBUG").trim();
        this.m_logLevel = PaxLoggingServiceImpl.convertLevel(levelName);
        PaxLoggingConfigurator configurator = new PaxLoggingConfigurator(this.m_appenderTracker);
        Properties defaultProperties = new Properties();
        defaultProperties.put("log4j.rootLogger", PaxLoggingServiceImpl.convertLevel(this.m_logLevel) + ", A1");
        defaultProperties.put("log4j.appender.A1", "org.apache.log4j.ConsoleAppender");
        defaultProperties.put("log4j.appender.A1.layout", "org.apache.log4j.TTCCLayout");
        configurator.doConfigure(defaultProperties, LogManager.getLoggerRepository());
    }

    static Event createEvent(Bundle bundle, int level, LogEntry entry, String message, Throwable exception, ServiceReference sr, Map context) {
        String type;
        switch (level) {
            case 1: {
                type = "LOG_ERROR";
                break;
            }
            case 2: {
                type = "LOG_WARNING";
                break;
            }
            case 3: {
                type = "LOG_INFO";
                break;
            }
            case 4: {
                type = "LOG_DEBUG";
                break;
            }
            default: {
                type = "LOG_OTHER";
            }
        }
        String topic = "org/osgi/service/log/LogEntry/" + type;
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        if (bundle != null) {
            ((Dictionary)props).put("bundle", bundle);
            Long bundleId = new Long(bundle.getBundleId());
            ((Dictionary)props).put("bundle.id", bundleId);
            String symbolicName = bundle.getSymbolicName();
            if (symbolicName != null) {
                ((Dictionary)props).put("bundle.symbolicname", symbolicName);
            }
        }
        ((Dictionary)props).put("log.level", new Integer(level));
        ((Dictionary)props).put("log.entry", entry);
        if (null != message) {
            ((Dictionary)props).put("message", message);
        }
        ((Dictionary)props).put("timestamp", new Long(System.currentTimeMillis()));
        if (exception != null) {
            ((Dictionary)props).put("exception", exception);
            ((Dictionary)props).put("exception.class", exception.getClass());
            if (exception.getMessage() != null) {
                ((Dictionary)props).put("exception.message", exception.getMessage());
            }
        }
        if (sr != null) {
            ((Dictionary)props).put("service", sr);
            Long id = (Long)sr.getProperty("service.id");
            ((Dictionary)props).put("service.id", id);
            String pid = (String)sr.getProperty("service.pid");
            if (pid != null) {
                ((Dictionary)props).put("service.pid", pid);
            }
            String[] objClass = (String[])sr.getProperty("objectClass");
            ((Dictionary)props).put("service.objectClass", objClass);
        }
        if (context != null) {
            Iterator keys = context.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                ((Dictionary)props).put(key, context.get(key));
            }
        }
        return new Event(topic, props);
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        class ManagedPaxLoggingService
        implements PaxLoggingService,
        LogService,
        ManagedService {
            private final /* synthetic */ Bundle val$bundle;

            ManagedPaxLoggingService(Bundle bundle) {
                this.val$bundle = bundle;
            }

            public void log(int level, String message) {
                PaxLoggingServiceImpl.this.log(this.val$bundle, null, level, message, null);
            }

            public void log(int level, String message, Throwable exception) {
                PaxLoggingServiceImpl.this.log(this.val$bundle, null, level, message, exception);
            }

            public void log(ServiceReference sr, int level, String message) {
                PaxLoggingServiceImpl.this.log(this.val$bundle, sr, level, message, null);
            }

            public void log(ServiceReference sr, int level, String message, Throwable exception) {
                PaxLoggingServiceImpl.this.log(this.val$bundle, sr, level, message, exception);
            }

            public int getLogLevel() {
                return PaxLoggingServiceImpl.this.getLogLevel();
            }

            public PaxLogger getLogger(Bundle myBundle, String category, String fqcn) {
                return PaxLoggingServiceImpl.this.getLogger(myBundle, category, fqcn);
            }

            public void updated(Dictionary configuration) throws ConfigurationException {
                PaxLoggingServiceImpl.this.updated(configuration);
            }

            public PaxContext getPaxContext() {
                return PaxLoggingServiceImpl.this.getPaxContext();
            }
        }
        return new ManagedPaxLoggingService(bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    public PaxContext getPaxContext() {
        return this.m_context;
    }

    private static int convertLevel(String levelName) {
        if ("DEBUG".equals(levelName)) {
            return 4;
        }
        if ("INFO".equals(levelName)) {
            return 3;
        }
        if ("ERROR".equals(levelName)) {
            return 1;
        }
        return 4;
    }

    private static String convertLevel(int level) {
        switch (level) {
            case 4: {
                return "DEBUG";
            }
            case 3: {
                return "INFO";
            }
            case 1: {
                return "ERROR";
            }
        }
        return "DEBUG";
    }
}

