/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.finder.FactoryFinder;
import org.apache.servicemix.jdbc.JDBCAdapter;
import org.apache.servicemix.jdbc.adapter.DefaultJDBCAdapter;

public final class JDBCAdapterFactory {
    private static final Log LOG = LogFactory.getLog(JDBCAdapterFactory.class);
    private static FactoryFinder factoryFinder = new FactoryFinder("META-INF/services/org/apache/servicemix/jdbc/");

    private JDBCAdapterFactory() {
    }

    public static JDBCAdapter getAdapter(Connection connection) {
        JDBCAdapter adapter = null;
        try {
            String driverName = connection.getMetaData().getDriverName();
            driverName = driverName.replaceAll("[^a-zA-Z0-9\\-]", "_").toLowerCase();
            try {
                adapter = (JDBCAdapter)factoryFinder.newInstance(driverName);
                LOG.info((Object)("Database driver recognized: [" + driverName + "]"));
            }
            catch (Throwable e) {
                LOG.warn((Object)("Database driver NOT recognized: [" + driverName + "].  Will use default JDBC implementation."));
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)("JDBC error occurred while trying to detect database type.  Will use default JDBC implementation: " + e.getMessage()));
            JDBCAdapterFactory.log("Failure details: ", e);
        }
        if (adapter == null) {
            adapter = new DefaultJDBCAdapter();
        }
        return adapter;
    }

    public static void log(String msg, SQLException e) {
        if (LOG.isDebugEnabled()) {
            String s = msg + e.getMessage();
            while (e.getNextException() != null) {
                e = e.getNextException();
                s = s + ", due to: " + e.getMessage();
            }
            LOG.debug((Object)s, (Throwable)e);
        }
    }
}

