/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Window {
    private static final Logger log = LoggerFactory.getLogger(Window.class);
    private final AbstractChannel channel;
    private final Object lock;
    private final String name;
    private int size;
    private int maxSize;
    private int packetSize;
    private boolean waiting;

    public Window(AbstractChannel channel, Object lock, boolean client, boolean local) {
        this.channel = channel;
        this.lock = lock != null ? lock : this;
        this.name = (client ? "client" : "server") + " " + (local ? "local " : "remote") + " window";
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void init(int size, int packetSize) {
        this.size = size;
        this.maxSize = size;
        this.packetSize = packetSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(int window) {
        Object object = this.lock;
        synchronized (object) {
            this.size += window;
            if (log.isDebugEnabled()) {
                log.debug("Increase " + this.name + " by " + window + " up to " + this.size);
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(int len) {
        Object object = this.lock;
        synchronized (object) {
            this.size -= len;
            if (log.isTraceEnabled()) {
                log.trace("Consume " + this.name + " by " + len + " down to " + this.size);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeAndCheck(int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.size -= len;
            if (log.isTraceEnabled()) {
                log.trace("Consume " + this.name + " by " + len + " down to " + this.size);
            }
            this.check(this.maxSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(int maxFree) throws IOException {
        int threshold = Math.min(this.packetSize * 8, this.maxSize / 4);
        Object object = this.lock;
        synchronized (object) {
            if (maxFree - this.size > this.packetSize && (maxFree - this.size > threshold || this.size < threshold)) {
                if (log.isDebugEnabled()) {
                    log.debug("Increase " + this.name + " by " + (maxFree - this.size) + " up to " + maxFree);
                }
                this.channel.sendWindowAdjust(maxFree - this.size);
                this.size = maxFree;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndConsume(int len) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.size < len) {
                log.debug("Waiting for {} bytes on {}", (Object)len, (Object)this.name);
                this.waiting = true;
                this.lock.wait();
            }
            if (this.waiting) {
                log.debug("Space available for {}", (Object)this.name);
                this.waiting = false;
            }
            this.size -= len;
            if (log.isTraceEnabled()) {
                log.trace("Consume " + this.name + " by " + len + " down to " + this.size);
            }
        }
    }
}

