/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth;

import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Signature;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthPublicKey
implements UserAuth {
    public Object auth(ServerSession session, String username, Buffer buffer) throws Exception {
        boolean hasSig = buffer.getBoolean();
        String alg = buffer.getString();
        int oldLim = buffer.wpos();
        int oldPos = buffer.rpos();
        int len = buffer.getInt();
        buffer.wpos(buffer.rpos() + len);
        PublicKey key = buffer.getPublicKey();
        String keyAlg = key instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss";
        Signature verif = (Signature)NamedFactory.Utils.create(session.getFactoryManager().getSignatureFactories(), keyAlg);
        verif.init(key, null);
        buffer.wpos(oldLim);
        byte[] sig = hasSig ? buffer.getBytes() : null;
        PublickeyAuthenticator authenticator = session.getServerFactoryManager().getPublickeyAuthenticator();
        if (authenticator == null) {
            throw new Exception("No PublickeyAuthenticator configured");
        }
        if (!hasSig) {
            if (authenticator.hasKey(username, key, session)) {
                Buffer buf = session.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_PK_OK);
                buf.putString(alg);
                buf.putRawBytes(buffer.array(), oldPos, 4 + len);
                session.writePacket(buf);
                return null;
            }
            throw new Exception("Unsupported key for user");
        }
        if (!authenticator.hasKey(username, key, session)) {
            throw new Exception("Unsupported key for user");
        }
        Buffer buf = new Buffer();
        buf.putString(session.getKex().getH());
        buf.putCommand(SshConstants.Message.SSH_MSG_USERAUTH_REQUEST);
        buf.putString(username);
        buf.putString("ssh-connection");
        buf.putString("publickey");
        buf.putByte((byte)1);
        buf.putString(keyAlg);
        buffer.rpos(oldPos);
        buffer.wpos(oldPos + 4 + len);
        buf.putBuffer(buffer);
        verif.update(buf.array(), buf.rpos(), buf.available());
        if (verif.verify(sig)) {
            return username;
        }
        throw new Exception("Key verification failed");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<UserAuth> {
        @Override
        public String getName() {
            return "publickey";
        }

        @Override
        public UserAuth create() {
            return new UserAuthPublicKey();
        }
    }
}

